////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2008.
// -------------------------------------------------------------------------
//  File name:   WeaponEditorPreviewDialog.cpp
//  Version:     v1.00
//  Created:     18-02-2008 by Evgeny Strokov
//  Compilers:   Visual Studio.NET 2005
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "WeaponEditorPreviewDialog.h"
#include "CharacterEditor/ModelViewportCE.h"

#include <ICryAnimation.h>
#include <IItem.h>

#include "..\..\GameK01\GameDll\WeaponAttachment.h"

#include "..\RenderHelpers\AxisHelper.h"
#include "arcball.h"
#include "WeaponEditorSettingsDialog.h"

#define MULTIPLY (2)

IMPLEMENT_DYNAMIC(CWeaponEditorPreviewDialog, CToolbarDialog)

//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CWeaponEditorPreviewDialog, CToolbarDialog)
	ON_WM_SIZE()
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CWeaponViewport, CModelViewportCE)

	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()

END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////
// CWeaponEditorPreviewDialog
//////////////////////////////////////////////////////////////////////////
CWeaponEditorPreviewDialog::CWeaponEditorPreviewDialog() : CToolbarDialog(IDD,NULL)
{
	m_pModelViewport = 0;
}

//////////////////////////////////////////////////////////////////////////
CWeaponEditorPreviewDialog::~CWeaponEditorPreviewDialog()
{
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorPreviewDialog::OnSize(UINT nType, int cx, int cy)
{
	__super::OnSize(nType, cx, cy);

	CRect rcClient;
	GetClientRect(rcClient);

	if (!m_pModelViewport || !m_pModelViewport->m_hWnd)
		return;

	rcClient.bottom = rcClient.top + (rcClient.right - rcClient.left) / m_pModelViewport->GetAspectRatio();
	m_pModelViewport->MoveWindow( rcClient );
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorPreviewDialog::DoDataExchange(CDataExchange* pDX)
{
	__super::DoDataExchange(pDX);
}


//////////////////////////////////////////////////////////////////////////
BOOL CWeaponEditorPreviewDialog::OnInitDialog()
{
	CRect rcClient;
	GetClientRect(rcClient);

	m_pModelViewport = new CWeaponViewport;
	m_pModelViewport->SetType( ET_ViewportModel );
	m_pModelViewport->SetParent(this);
	m_pModelViewport->MoveWindow(rcClient);
	m_pModelViewport->ShowWindow(SW_SHOW);

	RecalcLayout();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorPreviewDialog::RedrawPreview()
{
	if (m_pModelViewport)
		m_pModelViewport->Update();
}

////////////////////////////////////////////////////////////////////////////
//ICharacterInstance* CWeaponEditorPreviewDialog::GetCharacter()
//{
//	ICharacterInstance* pInstance = 0;
//	if (m_pModelViewport)
//		pInstance = m_pModelViewport->GetCharacterBase();
//	return pInstance;
//}
//
////////////////////////////////////////////////////////////////////////////
//void CWeaponEditorPreviewDialog::SetCharacter(const char* szCharacterName)
//{
//	m_sCharacterName = szCharacterName;
//	if ( m_pModelViewport )
//		m_pModelViewport->LoadObject( m_sCharacterName.c_str() );
//}

CWeaponViewport::CWeaponViewport() 
: CModelViewportCE()
, m_pWeapon(NULL)
, m_isFPCamera(false)
, m_isZoomed(false)
, m_pSettingsDialog(NULL)
{
	m_pAxisHelper.reset(new CAxisHelper);
	m_pArcBall.reset(new CArcBall3D);
	m_pArcBall->InitArcBall();
	UseWeaponIK(true); 
	m_Button_MOVE = 1;
}

void CWeaponViewport::SetSettingsDialog(CWeaponEditorSettingsDialog* pSettingsDialog)
{
	m_pSettingsDialog = pSettingsDialog;
}


void CWeaponViewport::OnLButtonDown(UINT nFlags, CPoint point)
{
	HitContext hitContext;
	hitContext.view = this;
	hitContext.b2DViewport = false;
	hitContext.point2d = point;
	ViewToWorldRay( point, hitContext.raySrc, hitContext.rayDir );
	hitContext.distanceTollerance = 0;

	Matrix34 m;
	if (m_pSettingsDialog && m_pSettingsDialog->GetSelectedHelperPos(m))
	{
		m_MouseButtonL = true;
		m_cMouseDownPos = point;
		if (m_pAxisHelper->HitTest(m, hitContext))
		{
			SetAxisConstrain( hitContext.axis );
			GetIEditor()->SetAxisConstrains( (AxisConstrains)hitContext.axis );
			SetConstructionMatrix( COORDS_LOCAL, m );
			if (m_Button_MOVE)
				m_opMode = MoveMode;
			return;
		}
		
		if (m_Button_ROTATE)
			m_opMode = RotateMode;
		m_pArcBall->DragRotation.SetIdentity();
		SetConstructionMatrix(COORDS_LOCAL, m);
	}
}

void CWeaponViewport::OnLButtonUp(UINT nFlags, CPoint point)
{
	if (m_Button_ROTATE && m_opMode == RotateMode)
	{
		m_pArcBall->ObjectRotation = m_pArcBall->DragRotation*m_pArcBall->ObjectRotation;
		m_pSettingsDialog->RotateSelectedHelper(m_pArcBall->DragRotation);
		m_pArcBall->DragRotation.SetIdentity();
	}

	m_opMode = SelectMode;
	m_MouseButtonL = false;
}

void CWeaponViewport::OnMouseMove(UINT nFlags, CPoint point)
{
	CRenderViewport::OnMouseMove(nFlags,point);

	if (m_opMode == MoveMode)
	{
		Vec3 p1 = MapViewToCP(m_cMouseDownPos);
		Vec3 p2 = MapViewToCP(point);
		if (p1.IsZero() || p2.IsZero())
			return;
		Vec3 v = GetCPVector(p1, p2);

		m_cMouseDownPos = point;
		m_pSettingsDialog->MoveSelectedHelper(v);
	}

	if (m_Button_ROTATE)
	{
		GetWindowRect(m_WinRect);
		f32 RresX=(f32)(m_WinRect.right-m_WinRect.left); 
		f32 RresY=(f32)(m_WinRect.bottom-m_WinRect.top);
		f32 MiddleX=RresX/2.0f;
		f32 MiddleY=RresY/2.0f;
		CCamera cam = m_renderer->GetCamera();
		Vec3 MoursePos3D = Vec3( point.x-MiddleX, cam.GetEdgeP().y, -point.y+MiddleY ) * Matrix33(cam.GetViewMatrix()) + cam.GetPosition();
		Ray mray(cam.GetPosition(),(MoursePos3D-cam.GetPosition()).GetNormalized() );

		m_pArcBall->ArcControl(mray, m_MouseButtonL);

		/*m_pArcBall->ObjectRotation = m_pArcBall->DragRotation*m_pArcBall->ObjectRotation;
		m_pSettingsDialog->RotateSelectedHelper(m_pArcBall->DragRotation);
		m_pArcBall->DragRotation.SetIdentity();*/

	/*	q.Normalize();

		int i=0;
		if (!q.IsValid())
		{
			q.SetIdentity();
		}*/

		//m_pSettingsDialog->RotateSelectedHelper(q);
	}
}

void CWeaponViewport::OnRender()
{
	Vec3 clearColor = mv_backgroundColor;
	m_renderer->SetClearColor( clearColor );
	m_renderer->SetCamera( m_Camera );

	m_renderer->ClearBuffer(FRT_CLEAR, &ColorF(clearColor, 1.0f));
	m_renderer->ResetToDefault();

	IRenderAuxGeom* pAuxGeom = m_renderer->GetIRenderAuxGeom();
	SAuxGeomRenderFlags renderFlags( e_Def3DPublicRenderflags );
	renderFlags.SetFillMode( e_FillModeSolid );
	pAuxGeom->SetRenderFlags( renderFlags );

	m_renderer->EF_StartEf();

	DrawSkyBox();

	float frameTime = GetIEditor()->GetSystem()->GetITimer()->GetFrameTime();
	if (m_pWeapon)
	{
		m_pWeapon->GetIItemView()->UpdateFPView(frameTime);

		Matrix34 view;
		view.SetIdentity();
		if (m_isFPCamera)
			this->SetViewTM(view);

		if (IEntityRenderProxy* proxy = static_cast<IEntityRenderProxy*>(m_pWeapon->GetGameObject()->GetEntity()->GetProxy(ENTITY_PROXY_RENDER)))
		{
			CCamera cam = m_renderer->GetCamera();
			float n_fov = DEG2RAD(m_isFPCamera ? gEnv->pConsole->GetCVar("i_offset_nearFOV")->GetFVal() : 60.f);
			cam.SetFrustum(cam.GetViewSurfaceX(), cam.GetViewSurfaceZ(), n_fov, cam.GetNearPlane(), cam.GetFarPlane());
			m_renderer->SetCamera(cam);
			m_displayContext.camera->SetFrustum(cam.GetViewSurfaceX(), cam.GetViewSurfaceZ(), cam.GetFov(), cam.GetNearPlane(), cam.GetFarPlane());

			// Axis helper
			Matrix34 m;
			if (m_pSettingsDialog && m_pSettingsDialog->GetSelectedHelperPos(m))
			{
				if (m_pAxisHelper->GetHighlightAxis() == 0)
					m_pAxisHelper->SetHighlightAxis( GetAxisConstrain() );

				if (m_Button_MOVE)
				{
					m_pAxisHelper->SetMode(CAxisHelper::MOVE_MODE);
					m_pAxisHelper->DrawAxis(m, m_displayContext);
				}

				if (m_Button_ROTATE)
				{
					//m_pAxisHelper->SetMode(CAxisHelper::ROTATE_MODE);
					if (!m_MouseButtonL)
					{
						QuatT p(m);
						m_pArcBall->ObjectRotation = p.q;
						m_pArcBall->sphere.center	 = p.t; 
					}
					m_pArcBall->Draw_Sphere(cam, pAuxGeom);
				}
					
			}
			//-Axis helper

			// Lights
			Matrix33 LightRot33	=	Matrix33::CreateRotationZ(m_LightRotationRadiant);

			float orbit = 15;
			Vec3 LPos0 = Vec3(-orbit,orbit,orbit); 
			m_VPLights[0].m_Origin = LightRot33*LPos0;
			Vec3 d0 = mv_lightDiffuseColor0;
			m_VPLights[0].SetLightColor(ColorF(d0.x*MULTIPLY,d0.y*MULTIPLY,d0.z*MULTIPLY,0));
			m_VPLights[0].m_SpecMult = 1.0f;
			m_VPLights[0].m_fRadius = 400;
			m_VPLights[0].m_fStartRadius = 5;
			m_VPLights[0].m_fEndRadius = 400;
			m_VPLights[0].m_Flags |= DLF_POINT;

			//-----------------------------------------------

			Vec3 LPos1 = Vec3(-orbit,-orbit,-orbit/2); 
			m_VPLights[1].m_Origin = LightRot33*LPos1;
			Vec3 d1 = mv_lightDiffuseColor1;
			m_VPLights[1].SetLightColor(ColorF(d1.x*MULTIPLY,d1.y*MULTIPLY,d1.z*MULTIPLY,0));
			m_VPLights[1].m_SpecMult = 1.0f;
			m_VPLights[1].m_fRadius = 400;
			m_VPLights[1].m_fStartRadius = 5;
			m_VPLights[1].m_fEndRadius = 400;
			m_VPLights[1].m_Flags |= DLF_POINT;

			//---------------------------------------------

			Vec3 LPos2 = Vec3(orbit,-orbit,0); 
			m_VPLights[2].m_Origin = LightRot33*LPos2;
			Vec3 d2 = mv_lightDiffuseColor2;
			m_VPLights[2].SetLightColor(ColorF(d2.x*MULTIPLY,d2.y*MULTIPLY,d2.z*MULTIPLY,0));
			m_VPLights[2].m_SpecMult = 1.0f;
			m_VPLights[2].m_fRadius = 400;
			m_VPLights[2].m_fStartRadius = 5;
			m_VPLights[2].m_fEndRadius = 400;
			m_VPLights[2].m_Flags |= DLF_POINT;

			m_renderer->EF_ADDDlight( &m_VPLights[0] );
			m_renderer->EF_ADDDlight( &m_VPLights[1] );
			m_renderer->EF_ADDDlight( &m_VPLights[2] );
			// -Lights

			// LOD
			IConsole* pIConsole = GetIEditor()->GetSystem()->GetIConsole();
			ICVar* pICVar = pIConsole->GetCVar("e_lod_ratio");
			if (pICVar)
				pICVar->Set( 6.0f );

			f32 fDistance = GetViewTM().GetTranslation().GetLength();
			if (mv_disableLod)
			{
				fDistance = 0;
				if (pICVar)
					pICVar->Set( 999999.0f );
			}
			// -LOD

			// RP
			SRendParams rp;
			rp.fDistance	= fDistance;
			Matrix34 tm; tm.SetIdentity();
			rp.pMatrix = &tm;
			rp.pPrevMatrix = &tm;

			Vec3 vAmbient;
			mv_objectAmbientColor.Get(vAmbient);

			rp.AmbientColor.r=vAmbient.x*MULTIPLY;
			rp.AmbientColor.g=vAmbient.y*MULTIPLY;
			rp.AmbientColor.b=vAmbient.z*MULTIPLY;
			rp.AmbientColor.a = 1;

			rp.nDLightMask = 7;
			if (mv_lighting == true)rp.nDLightMask = 0xffff;
			else rp.nDLightMask = 0;
			rp.nDLightMask;

			rp.dwFObjFlags  = 0;
			rp.dwFObjFlags |= FOB_TRANS_MASK;
			if (m_pCurrentMaterial)
				rp.pMaterial = m_pCurrentMaterial->GetMatInfo();
			// -RP

			// Character
			if (ICharacterInstance* pInstance = m_pWeapon->GetGameObject()->GetEntity()->GetCharacter(0))
			{
				IRenderAuxGeom* pAuxGeom = m_renderer->GetIRenderAuxGeom();
				SAuxGeomRenderFlags renderFlags( e_Def3DPublicRenderflags );
				pAuxGeom->SetRenderFlags( renderFlags );

				GetISystem()->GetIAnimationSystem()->SetScalingLimits( Vec2(0.1f, 7.5f) );

				ISkeletonAnim* pISkeletonAnim = pInstance->GetISkeletonAnim();
				ISkeletonPose* pISkeletonPose = pInstance->GetISkeletonPose();

				pISkeletonAnim->SetCharEditMode(1);
				pISkeletonPose->SetForceSkeletonUpdate(1);

				int PreProcessCallback(ICharacterInstance* pInstance, void* pPlayer);
				pISkeletonAnim->SetPreProcessCallback(PreProcessCallback,this);

				int AnimEventCallback(ICharacterInstance* pInstance, void* pPlayer);
				pISkeletonAnim->SetEventCallback(AnimEventCallback,this);

				m_PhysEntityLocation.q.SetRotationZ( 0.0f );
				m_PhysEntityLocation.t = Vec3(ZERO);

				m_AnimatedCharacter.t.x	=	0.0f;
				m_AnimatedCharacter.t.y	=	0.0f;

				pInstance->SkeletonPreProcess( m_PhysEntityLocation, m_AnimatedCharacter, GetCamera(), 0 );
				pInstance->SkeletonPostProcess( m_PhysEntityLocation, m_AnimatedCharacter, 0, (m_PhysEntityLocation.t-m_absCameraPos).GetLength(), 0 );
			}
			// -Character

			m_EntityMat			=	Matrix34(m_PhysEntityLocation);
			rp.pMatrix			= &m_EntityMat;
			rp.pPrevMatrix	= &m_PrevEntityMat;
			rp.fDistance		= (m_PhysEntityLocation.t-m_Camera.GetPosition()).GetLength();


			m_pWeapon->GetGameObject()->GetEntity()->FreeSlot(2);

			if (m_pWeapon->GetIItemEdit()->GetPinHelpersCount())
			{
				if (const IItem* att = m_pSettingsDialog->GetAttachedItem())
				{
					att->GetGameObject()->GetEntity()->SetWorldTM(m_pSettingsDialog->GetAttachedItemTM());
					att->GetGameObject()->GetEntity()->FreeSlot(2);
					for (int slot=0; slot<att->GetGameObject()->GetEntity()->GetSlotCount(); ++slot)
					{
						uint flags = att->GetGameObject()->GetEntity()->GetSlotFlags(slot);
						flags &= ~ENTITY_SLOT_RENDER_NEAREST;
						att->GetGameObject()->GetEntity()->SetSlotFlags(slot, flags);
					}
					IEntityRenderProxy* attProxy = static_cast<IEntityRenderProxy*>(att->GetGameObject()->GetEntity()->GetProxy(ENTITY_PROXY_RENDER));
					attProxy->GetRenderNode()->Render(rp);
				}

				Matrix34 zoomHelper;
				if (m_isZoomed && m_pSettingsDialog && m_pSettingsDialog->GetHelperPos("zoom_helper", zoomHelper))
				{
					cam.SetMatrix(zoomHelper);
					gEnv->pRenderer->SetCamera(cam);

					// Show AUX model
					uint flags = m_pWeapon->GetGameObject()->GetEntity()->GetSlotFlags(3);
					flags |= ENTITY_SLOT_RENDER;
					m_pWeapon->GetGameObject()->GetEntity()->SetSlotFlags(3, flags);

					// Hide FP model
					flags = m_pWeapon->GetGameObject()->GetEntity()->GetSlotFlags(0);
					flags &= ~ENTITY_SLOT_RENDER;
					m_pWeapon->GetGameObject()->GetEntity()->SetSlotFlags(0, flags);

					// Draw cross
					float fHalfWidth = m_renderer->GetWidth()*0.5f;
					float fHalfHeight = m_renderer->GetHeight()*0.5f;
					Vec3 v0, v1;
					m_renderer->UnProjectFromScreen(fHalfWidth - 25.0f, fHalfHeight, 0.0f, &v0.x, &v0.y, &v0.z);
					m_renderer->UnProjectFromScreen(fHalfWidth + 25.0f, fHalfHeight, 0.0f, &v1.x, &v1.y, &v1.z);
					pAuxGeom->DrawLine(v0, ColorB(0xff, 0xff, 0x00), v1, ColorB(0xff, 0xff, 0x00));
					m_renderer->UnProjectFromScreen(fHalfWidth, fHalfHeight - 25.0f, 0.0f, &v0.x, &v0.y, &v0.z);
					m_renderer->UnProjectFromScreen(fHalfWidth, fHalfHeight + 25.0f, 0.0f, &v1.x, &v1.y, &v1.z);
					pAuxGeom->DrawLine(v0, ColorB(0xff, 0xff, 0x00), v1, ColorB(0xff, 0xff, 0x00));

					Matrix34 auxHelper;
					if (m_pSettingsDialog->GetHelperPos("aux_helper", auxHelper))
						m_pWeapon->GetGameObject()->GetEntity()->SetSlotLocalTM(3, auxHelper);
				}
				else
				{
					// Hide AUX model
					uint flags = m_pWeapon->GetGameObject()->GetEntity()->GetSlotFlags(3);
					flags &= ~ENTITY_SLOT_RENDER;
					m_pWeapon->GetGameObject()->GetEntity()->SetSlotFlags(3, flags);

					// Show FP model
					flags = m_pWeapon->GetGameObject()->GetEntity()->GetSlotFlags(0);
					flags |= ENTITY_SLOT_RENDER;
					m_pWeapon->GetGameObject()->GetEntity()->SetSlotFlags(0, flags);
				}
			}

			for (int slot=0; slot<m_pWeapon->GetGameObject()->GetEntity()->GetSlotCount(); ++slot)
			{
				uint flags = m_pWeapon->GetGameObject()->GetEntity()->GetSlotFlags(slot);
				flags &= ~(ENTITY_SLOT_RENDER_NEAREST | ENTITY_SLOT_RENDER_IN_CAMERA_SPACE);
				//fix for double arms
				if(slot && m_pWeapon->GetGameObject()->GetEntity()->GetCharacter(slot))
					flags &= ~ENTITY_SLOT_RENDER;
				m_pWeapon->GetGameObject()->GetEntity()->SetSlotFlags(slot, flags);
			}
			proxy->GetRenderNode()->Render(rp);
		}
	}
	m_renderer->EF_EndEf3D(SHDF_SORT/* | SHDF_ZPASS*/);
}

void CWeaponViewport::SetWeapon(IItem* pWeapon) 
{ 
	m_pWeapon = pWeapon;
}
