////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   fileutil.h
//  Version:     v1.00
//  Created:     13/9/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History: 
//	HINT - Add a file traversal function with a callback.
////////////////////////////////////////////////////////////////////////////

#ifndef __fileutil_h__
#define __fileutil_h__

#if _MSC_VER > 1000
#pragma once
#endif

/* File types used for File Open dialogs.
*	
*/
enum ECustomFileType
{
	EFILE_TYPE_ANY,
	EFILE_TYPE_GEOMETRY,
	EFILE_TYPE_TEXTURE,
	EFILE_TYPE_SOUND,
	EFILE_TYPE_DIALOG,
	EFILE_TYPE_LAST,
};

//////////////////////////////////////////////////////////////////////////
class SANDBOX_API CFileUtil
{
public:
	struct FileDesc
	{
		CString filename;
		unsigned int attrib;
		time_t  time_create;    //! -1 for FAT file systems
		time_t  time_access;    //! -1 for FAT file systems
		time_t  time_write;
		int64 size;
	};
	enum ETextFileType
	{
		FILE_TYPE_SCRIPT,
		FILE_TYPE_SHADER
	};

	enum ECopyTreeResult
	{
		ETREECOPYOK,
		ETREECOPYFAIL,
		ETREECOPYUSERCANCELED,
		ETREECOPYUSERDIDNTCOPYSOMEITEMS,
	};

	typedef std::vector<FileDesc> FileArray;

	static bool ScanDirectory( const CString &path,const CString &fileSpec,FileArray &files, bool recursive=true );
	//static bool ScanDirectory( const CString &startDirectory,const CString &searchPath,const CString &fileSpecZ,FileArray &files, bool recursive=true );

	//! Creates this directory.
	static void CreateDirectory( const char *dir );

	//! Makes a backup file.
	static void BackupFile( const char *filename );

	//! Makes a backup file, marked with a datestamp, e.g. myfile.20071014.093320.xml 
	//! If bUseBackupSubDirectory is true, moves backup file into a relative subdirectory "backups"
	static void BackupFileDated( const char *filename, bool bUseBackupSubDirectory=false );

	// ! Added deltree as a copy from the function found in Crypak.
	static bool Deltree(const char *szFolder, bool bRecurse);

	// Checks if a file or directory exist.
	// We are using 3 functions here in order to make the names more instructive for the programmers.
	// Those functions only work for OS files and directories.
	static bool   Exists(const CString& strPath,bool boDirectory);
	static bool   FileExists(const CString& strFilePath);
	static bool   PathExists(const CString& strPath);

	// Creates the entire path, if needed.
	static bool   CreatePath(const CString& strPath);

	// Attempts to delete a file (if read only it will set its attributes to normal first).
	static bool   DeleteFile(const CString& strPath);

	// Attempts to remove a directory (if read only it will set its attributes to normal first).
	static bool		RemoveDirectory(const CString& strPath);
};
#endif // __fileutil_h__
