/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AssetModelDatabase.h,v 1.0 2009/04/15 11:00:00 PauloZaffari Exp wwwrun $
$DateTime$
Description: Source file for the class implementing IAssetDisplay
interface. It declares the headers of the actual used 
functions.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/
#include "stdafx.h"

#include "Include/IEditorClassFactory.h"
#include "AssetModelDatabase.h"
#include "AssetModelItem.h"
#include "Include/IAssetViewer.h"

#include "Util/PathUtil.h"

//////////////////////////////////////////////////////////////////////////
CAssetDisplayDatabaseModel::CAssetDisplayDatabaseModel():
m_renderer(gEnv->pRenderer)
{
	m_poAssociatedViewer=NULL;
	m_boMustEndThread=false;
	m_boNewItemsShouldBeVisible=true;
	m_ref=1;
}
//////////////////////////////////////////////////////////////////////////
CAssetDisplayDatabaseModel::~CAssetDisplayDatabaseModel()
{
	FreeData();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::FreeData()
{
	TDFilenameToItemMap::iterator		itCurrentAsset;
	TDFilenameToItemMap::iterator		itEndAsset;

	itEndAsset=m_cKnwonModels.end();
	for (itCurrentAsset=m_cKnwonModels.begin();itCurrentAsset!=itEndAsset;itCurrentAsset++)
	{
		itCurrentAsset->second->Release();
	}
	m_cKnwonModels.clear();

	m_poAssociatedViewer=NULL;
}
//////////////////////////////////////////////////////////////////////////
bool CAssetDisplayDatabaseModel::SetAssociatedViewer(IAssetViewer* poAssociatedViewer)
{
	// Hot changing of associated viewer is not allowed, for now.
	if (m_poAssociatedViewer)
	{
		return false;
	}

	m_poAssociatedViewer=poAssociatedViewer;

	return true;
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::NotifyShutDown()
{
	m_poAssociatedViewer->BeginDatabaseLock();
	m_boMustEndThread=true;
	m_poAssociatedViewer->EndDatabaseLock();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::Lock()
{
	CryThread<CAssetDisplayDatabaseModel>::Lock();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::Unlock()
{
	CryThread<CAssetDisplayDatabaseModel>::Unlock();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::WaitForThread()
{
	CryThread<CAssetDisplayDatabaseModel>::WaitForThread();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::Start()
{
	CryThread<CAssetDisplayDatabaseModel>::Start();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::Stop()
{
	CryThread<CAssetDisplayDatabaseModel>::Stop();
}
//////////////////////////////////////////////////////////////////////////
const XmlNodeRef&		CAssetDisplayDatabaseModel::GetFilterOptionsDescription()
{
	if (!m_xmlFilterOptionsDescription)
	{
		XmlNodeRef	xmlCurrentNode;
		XmlNodeRef	xmlGroupNode;


		m_xmlFilterOptionsDescription=gEnv->pSystem->CreateXmlNode("FilterOptionsDescription");
		m_xmlFilterOptionsDescription->setAttr("AssetTypeName","Model");

		xmlGroupNode=m_xmlFilterOptionsDescription->newChild("Group");
		xmlGroupNode->setAttr("Name","Filename");

		xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		xmlCurrentNode->setAttr("Name","Filename");
		//xmlCurrentNode->setAttr("DisplayName","");
		xmlCurrentNode->setAttr("Type","string");
		//xmlCurrentNode->setAttr("Default","");


		//xmlGroupNode=m_xmlFilterOptionsDescription->newChild("Group");
		//xmlGroupNode->setAttr("Name","Texture Dimensions");

		////////////////////////////////////////////////////////////////////////////
		//// Enum sample
		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Minimum Width");
		//xmlCurrentNode->setAttr("DisplayName","Minimum Width");
		//xmlCurrentNode->setAttr("Type","enum");
		//xmlCurrentNode->setAttr("Default",0);

		//xmlCurrentNode=xmlCurrentNode->newChild("enum");
		//xmlCurrentNode->setAttr("0","Any");
		//xmlCurrentNode->setAttr("1","1");
		//xmlCurrentNode->setAttr("2","2");
		//xmlCurrentNode->setAttr("3","4");
		//xmlCurrentNode->setAttr("4","8");
		//xmlCurrentNode->setAttr("5","16");
		//xmlCurrentNode->setAttr("6","32");
		//xmlCurrentNode->setAttr("7","64");
		//xmlCurrentNode->setAttr("8","128");
		//xmlCurrentNode->setAttr("9","256");
		//xmlCurrentNode->setAttr("10","512");
		//xmlCurrentNode->setAttr("11","1024");
		//xmlCurrentNode->setAttr("12","2048");
		//xmlCurrentNode->setAttr("13","4096");
		//xmlCurrentNode->setAttr("14","8192");
		//xmlCurrentNode->setAttr("15","16384");
		////////////////////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////////////////////
		//// Enum sample
		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Maximum Width");
		//xmlCurrentNode->setAttr("DisplayName","Maximum Width");
		//xmlCurrentNode->setAttr("Type","enum");
		//xmlCurrentNode->setAttr("Default",0);

		//xmlCurrentNode=xmlCurrentNode->newChild("enum");
		//xmlCurrentNode->setAttr("0","Any");
		//xmlCurrentNode->setAttr("1","1");
		//xmlCurrentNode->setAttr("2","2");
		//xmlCurrentNode->setAttr("3","4");
		//xmlCurrentNode->setAttr("4","8");
		//xmlCurrentNode->setAttr("5","16");
		//xmlCurrentNode->setAttr("6","32");
		//xmlCurrentNode->setAttr("7","64");
		//xmlCurrentNode->setAttr("8","128");
		//xmlCurrentNode->setAttr("9","256");
		//xmlCurrentNode->setAttr("10","512");
		//xmlCurrentNode->setAttr("11","1024");
		//xmlCurrentNode->setAttr("12","2048");
		//xmlCurrentNode->setAttr("13","4096");
		//xmlCurrentNode->setAttr("14","8192");
		//xmlCurrentNode->setAttr("15","16384");
		////////////////////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////////////////////
		//// Enum sample
		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Minimum Height");
		//xmlCurrentNode->setAttr("DisplayName","Minimum Height");
		//xmlCurrentNode->setAttr("Type","enum");
		//xmlCurrentNode->setAttr("Default",0);

		//xmlCurrentNode=xmlCurrentNode->newChild("enum");
		//xmlCurrentNode->setAttr("0","Any");
		//xmlCurrentNode->setAttr("1","1");
		//xmlCurrentNode->setAttr("2","2");
		//xmlCurrentNode->setAttr("3","4");
		//xmlCurrentNode->setAttr("4","8");
		//xmlCurrentNode->setAttr("5","16");
		//xmlCurrentNode->setAttr("6","32");
		//xmlCurrentNode->setAttr("7","64");
		//xmlCurrentNode->setAttr("8","128");
		//xmlCurrentNode->setAttr("9","256");
		//xmlCurrentNode->setAttr("10","512");
		//xmlCurrentNode->setAttr("11","1024");
		//xmlCurrentNode->setAttr("12","2048");
		//xmlCurrentNode->setAttr("13","4096");
		//xmlCurrentNode->setAttr("14","8192");
		//xmlCurrentNode->setAttr("15","16384");
		////////////////////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////////////////////
		//// Enum sample
		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Maximum Height");
		//xmlCurrentNode->setAttr("DisplayName","Maximum Height");
		//xmlCurrentNode->setAttr("Type","enum");
		//xmlCurrentNode->setAttr("Default",0);

		//xmlCurrentNode=xmlCurrentNode->newChild("enum");
		//xmlCurrentNode->setAttr("0","Any");
		//xmlCurrentNode->setAttr("1","1");
		//xmlCurrentNode->setAttr("2","2");
		//xmlCurrentNode->setAttr("3","4");
		//xmlCurrentNode->setAttr("4","8");
		//xmlCurrentNode->setAttr("5","16");
		//xmlCurrentNode->setAttr("6","32");
		//xmlCurrentNode->setAttr("7","64");
		//xmlCurrentNode->setAttr("8","128");
		//xmlCurrentNode->setAttr("9","256");
		//xmlCurrentNode->setAttr("10","512");
		//xmlCurrentNode->setAttr("11","1024");
		//xmlCurrentNode->setAttr("12","2048");
		//xmlCurrentNode->setAttr("13","4096");
		//xmlCurrentNode->setAttr("14","8192");
		//xmlCurrentNode->setAttr("15","16384");
		////////////////////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////////////////////
		//xmlGroupNode=m_xmlFilterOptionsDescription->newChild("Group");
		//xmlGroupNode->setAttr("Name","Texture Semantics");

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Only Diffuse");
		//xmlCurrentNode->setAttr("DisplayName","Show Only Diffuse");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Only Specular");
		//xmlCurrentNode->setAttr("DisplayName","Show Only Specular");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Only Bump");
		//xmlCurrentNode->setAttr("DisplayName","Show Only Bump");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Cube Map");
		//xmlCurrentNode->setAttr("DisplayName","Show Cube Map");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);
		////////////////////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////////////////////
		//xmlGroupNode=m_xmlFilterOptionsDescription->newChild("Group");
		//xmlGroupNode->setAttr("Name","Texture Files");

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Only DDS");
		//xmlCurrentNode->setAttr("DisplayName","Show Only DDS");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Only TIF");
		//xmlCurrentNode->setAttr("DisplayName","Show Only TIF");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Used in Level");
		//xmlCurrentNode->setAttr("DisplayName","Used in Level");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Has Alpha Channel");
		//xmlCurrentNode->setAttr("DisplayName","Has Alpha Channel");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);

		//xmlCurrentNode=xmlGroupNode->newChild("Parameter");
		//xmlCurrentNode->setAttr("Name","Show Alpha Channel");
		//xmlCurrentNode->setAttr("DisplayName","Show Alpha Channel");
		//xmlCurrentNode->setAttr("Type","bool");
		//xmlCurrentNode->setAttr("Default",false);
		//////////////////////////////////////////////////////////////////////////
	}

	return m_xmlFilterOptionsDescription;
}
//////////////////////////////////////////////////////////////////////////
const XmlNodeRef&		CAssetDisplayDatabaseModel::GetDisplayInformationTemplate()
{
	if (!m_xmlInformationDisplayTemplate)
	{
		XmlNodeRef	xmlCurrentNode;

		//static XmlNodeRef	m_xmlInformationDisplayTemplate;
		m_xmlInformationDisplayTemplate=(XmlNodeRef)gEnv->pSystem->CreateXmlNode("AssetDisplayInformation");

		xmlCurrentNode=m_xmlInformationDisplayTemplate->newChild("Filename");
		xmlCurrentNode->setAttr("DisplayName","Filename:");
		xmlCurrentNode->setAttr("MultilineDisplay",true);
		xmlCurrentNode->setAttr("DisplayValue","No selection");

		xmlCurrentNode=m_xmlInformationDisplayTemplate->newChild("Filesize");
		xmlCurrentNode->setAttr("DisplayName","Size:");
		xmlCurrentNode->setAttr("MultilineDisplay",false);
		xmlCurrentNode->setAttr("ValueType","int");
		xmlCurrentNode->setAttr("MaySum",true);
		xmlCurrentNode->setAttr("DisplayValue",0);
	}

	return m_xmlInformationDisplayTemplate;
}
//////////////////////////////////////////////////////////////////////////
const char*					CAssetDisplayDatabaseModel::GetDatabaseName()
{
	return "Models";
}
//////////////////////////////////////////////////////////////////////////
void								CAssetDisplayDatabaseModel::SetVisibleStatus(bool bVisible)
{
	TDFilenameToItemMap::iterator	itCurrentIterator;
	TDFilenameToItemMap::iterator	itEndIterator;

	m_poAssociatedViewer->BeginDatabaseLock();
	m_boNewItemsShouldBeVisible=bVisible;

	itEndIterator=m_cKnwonModels.end();
	for 
		(
			itCurrentIterator=m_cKnwonModels.begin();
			itCurrentIterator!=itEndIterator;
			itCurrentIterator++
		)
	{
		if (m_boMustEndThread)
		{
			m_poAssociatedViewer->EndDatabaseLock();
			return;
		}
		itCurrentIterator->second->SetVisibleStatus(bVisible);
	}

	m_poAssociatedViewer->EndDatabaseLock();
}
//////////////////////////////////////////////////////////////////////////
bool	CAssetDisplayDatabaseModel::GetVisibleStatus()
{
	return m_boNewItemsShouldBeVisible;
}
//////////////////////////////////////////////////////////////////////////
IAssetDisplay*	CAssetDisplayDatabaseModel::GetItem(const char* szAddItem)
{
	if (!m_poAssociatedViewer)
	{
		return NULL;
	}

	if (strlen(szAddItem)==0)
	{
		return NULL;
	}

	m_poAssociatedViewer->BeginDatabaseLock();

	CAssetModelItem*											poReturn(NULL);
	CString                               strOriginalAddItem(szAddItem);
	CString                               strAddItem(szAddItem);
	//CString															  strExtension;
	CString																strOutputFilename;

	TDFilenameToItemMap::iterator				itIterator;
	itIterator=m_cKnwonModels.find(strAddItem.GetBuffer());
	if (itIterator!=m_cKnwonModels.end())
	{
		m_poAssociatedViewer->EndDatabaseLock();
		return itIterator->second;
	}

	CFileUtil::FileArray										cFiles;
	CString																	strPath(PathUtil::GetGameFolder().c_str());
	string																	strSurfaceType;

	strOutputFilename=strAddItem.GetBuffer();
	CFileUtil::ScanDirectory(strPath,strAddItem,cFiles,false);
	if (cFiles.empty())
	{	
		strOutputFilename=strOriginalAddItem.GetBuffer();
		CFileUtil::ScanDirectory(strPath,strOriginalAddItem,cFiles,false);
		if (cFiles.empty())
		{			
			m_poAssociatedViewer->EndDatabaseLock();
			return NULL;
		}				
	}

	// Here we must add the code to load a model and insert the model into the 
	// database when not found already in the database.
	assert(false);


	//int										nTextureWidth(0),nTextureHeight(0);
	//CFileUtil::FileDesc&	rstFileDescriptor=cFiles[0];
	//CImage								oImage;
	//CImageUtil::LoadImage(strOutputFilename.GetBuffer(),oImage);

	//Path::ConvertSlashToBackSlash(strOutputFilename);
	//strlwr((char*)strOutputFilename.GetBuffer());

	//nTextureWidth=oImage.GetWidth();
	//nTextureHeight=oImage.GetHeight();

	//strSurfaceType=oImage.GetFormatDescription();
	//poReturn=new CAssetModelItem();
	//poReturn->SetFileSize(rstFileDescriptor.size);
	//poReturn->SetSurfaceType(strSurfaceType);
	//poReturn->SetMips(1); // Currently setting to one... but we could have more accurate info on that.
	//poReturn->SetTextureWidth(oImage.GetWidth());
	//poReturn->SetTextureHeight(oImage.GetHeight());
	//poReturn->SetFilename(strOutputFilename.GetBuffer());
	//poReturn->SetUsedInLevel(true);
	//poReturn->SetOwnerDisplayDatabase(this);
	//poReturn->SetExtension(strExtension.GetBuffer());
	//poReturn->SetVisibleStatus(m_boNewItemsShouldBeVisible);
	//poReturn->SetOwnerModelDatabase(this);

	if (m_boMustEndThread)
	{				
		delete poReturn;
		m_poAssociatedViewer->EndDatabaseLock();
		return NULL;	
	}

	m_cKnwonModels.insert(TDInsertionElement(strOutputFilename.GetBuffer(),poReturn));
	m_poAssociatedViewer->AddAssetDatabaseItem(poReturn);

	m_poAssociatedViewer->EndDatabaseLock();

	return poReturn;
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::Run()
{
	if (!m_poAssociatedViewer)
	{
		return;
	}

	m_boMustEndThread=false;

	// Here we must add the code for finding models.
	AddPreLoadedModels(m_cKnwonModels);
	AddDiskModels(m_cKnwonModels);

	m_poAssociatedViewer->FinishedDatabaseUpdate(this);
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::AddPreLoadedModels(TDFilenameToItemMap& rcFilenameSet)
{
	// If no associated viewer, no need to add textures at all...
	if (!m_poAssociatedViewer)
	{
		// TOD: Must add a log entry about this.
		return;
	}

	m_poAssociatedViewer->BeginDatabaseLock();

	//std::vector<IRenderMesh*>				cpiMeshes;

	//int															nCurrentMesh(0);
	//int															nNumberOfMeshes(0);
	//const char*											szModelName(NULL);
	//string													strIntermediateModelName;
	//CString													strOutputModelName;
	//CString													strExtension;
	//CAssetModelItem*								poModelDatabaseItem(NULL);
	//CCryFile												oFile;
	//size_t													nFileSize(0);

	//nNumberOfMeshes=*(int *)gEnv->pRenderer->EF_Query(EFQ_GetAllMeshes,NULL);

	//cpiMeshes.resize(nNumberOfMeshes,NULL);
	//gEnv->pRenderer->EF_Query(EFQ_GetAllMeshes,(INT_PTR)&cpiMeshes.front());

	//for (nCurrentMesh=0;nCurrentMesh<nNumberOfMeshes;++nCurrentMesh,Unlock())
	//{
	//	IRenderMesh*& piCurrentModel=cpiMeshes[nCurrentMesh];
	//	//if (piCurrentModel->IsTextureLoaded())
	//	//{
	//		// Models without names are not important for us.
	//		szModelName=piCurrentModel->GetSourceName();
	//		if (!szModelName)
	//		{
	//			continue;
	//		}

	//		// We don't want empty names as well.
	//		if (strlen(szModelName)==0)
	//		{
	//			continue;
	//		}
	//	//}
	//	//else
	//	//{
	//	//	// For now we are not loading textures, just using the ones already loaded.
	//	//}

	//	strIntermediateModelName=szModelName;
	//	strIntermediateModelName.MakeLower();
	//	strOutputModelName=strIntermediateModelName;
	//	Path::ConvertSlashToBackSlash(strOutputModelName);
	//	strExtension=Path::GetExt(strOutputModelName);

	//	if (rcFilenameSet.find(strOutputModelName.GetBuffer())!=rcFilenameSet.end())
	//	{
	//		continue;
	//	}

	//	poModelDatabaseItem=new CAssetModelItem();

	//	//OBS: To get the file size we will need to check with the OS, as this information
	//	// is not stored anywhere else.
	//	// This may be QUITE slow.
	//	oFile.Open(szModelName,"rb");
	//	if (oFile.GetHandle())
	//	{
	//		nFileSize=oFile.GetLength();

	//	}
	//	else
	//	{
	//		nFileSize=0;
	//	}
	//	poModelDatabaseItem->SetFileSize(nFileSize); // A safe invalid value for now.
	//	oFile.Close();


	//	poModelDatabaseItem->SetOwnerDisplayDatabase(this);
	//	poModelDatabaseItem->SetExtension(strExtension.GetBuffer());

	//	// We are storing the original filename here for textures which come from the
	//	// the engine (without using backslashes) as it is done with all other  textures.
	//	// For some bizarre reason, if we did, the engine would have problems cashing the
	//	// textures. On the other hand, if we adopted as a standard the normal slashes
	//	// it seems that some textures loaded from the disk would have problems... so...
	//	// there doesn't seem to be a perfect cenario here.
	//	poModelDatabaseItem->SetFilename(strIntermediateModelName.c_str());
	//	//poModelDatabaseItem->SetFilename(strOutputModelName.c_str());

	//	poModelDatabaseItem->SetUsedInLevel(true);

	//	poModelDatabaseItem->SetVisibleStatus(m_boNewItemsShouldBeVisible);
	// poModelDatabaseItem->SetOwnerModelDatabase(this);

	//	m_poAssociatedViewer->AddAssetDatabaseItem(poModelDatabaseItem);

	//	rcFilenameSet.insert(TDInsertionElement(strOutputModelName.GetBuffer(),poModelDatabaseItem));
	//}

	m_poAssociatedViewer->EndDatabaseLock();
}
//////////////////////////////////////////////////////////////////////////
void CAssetDisplayDatabaseModel::AddDiskModels( TDFilenameToItemMap &rcFilenameSet )
{
	// If no associated viewer, no need to add textures at all...
	if (!m_poAssociatedViewer)
	{
		// TOD: Must add a log entry about this.
		return;
	}

	const char															*szModelName(NULL);
	CString																	strExtension;
	CString																	strFilename;

	CFileUtil::FileArray										cFiles;
	int																			nTotalFiles(0);
	int																			nCurrentFile(0);
	string																	strIntermediateFilename;
	CString																	strOutputModelName;

	CCryFile																file;

	CAssetModelItem*											poModelDatabaseItem(NULL);


	// Will first look for all files and just add those which are actually textures...
	// Responsiveness optimization: instead of traversing directories just once and check
	// all files, in order to have faster response times we do it twice: once for the .dds
	// files and once for .tif. As this is threaded, both searches will be MUCH faster alone
	// even though the combined time will be bigger.
	// Still, the method used will have some results MUCH faster and thus the user will
	// have time to have fun with them before the final results will be there.
	//CFileUtil::ScanDirectory(PathUtil::GetGameFolder().c_str(),"*.*"/*"*.*"*/,cFiles,true);

	CFileUtil::ScanDirectory(PathUtil::GetGameFolder().c_str(),"*.cgf"/*"*.*"*/,cFiles,true);
	// For every file, check if is a texture...
	nTotalFiles=cFiles.size();
	for (nCurrentFile=0;nCurrentFile<nTotalFiles;++nCurrentFile)
	{
		// Checks if we must do a premature thread killing.
		if (m_boMustEndThread)
		{
			return;
		}

		CFileUtil::FileDesc& rstFileDescriptor=cFiles[nCurrentFile];

		strIntermediateFilename=rstFileDescriptor.filename.GetBuffer();
		strIntermediateFilename.MakeLower();
		strOutputModelName=strIntermediateFilename;
		Path::ConvertSlashToBackSlash(strOutputModelName);

		// No need to load files already loaded by the engine...
		if (rcFilenameSet.find(strOutputModelName.GetBuffer())!=rcFilenameSet.end())
		{
			continue;
		}

		strExtension=Path::GetExt(strOutputModelName.GetBuffer());

		// Textures without names are not important for us.
		szModelName=strOutputModelName.GetBuffer();
		if (!szModelName)
		{
			continue;
		}

		poModelDatabaseItem=new CAssetModelItem();
		poModelDatabaseItem->SetFileSize(rstFileDescriptor.size);
		poModelDatabaseItem->SetFilename(strOutputModelName.GetBuffer());
		poModelDatabaseItem->SetUsedInLevel(false);
		poModelDatabaseItem->SetOwnerDisplayDatabase(this);
		poModelDatabaseItem->SetExtension(strExtension.GetBuffer());
		poModelDatabaseItem->SetVisibleStatus(m_boNewItemsShouldBeVisible);

		m_poAssociatedViewer->BeginDatabaseLock();
		if (!m_boMustEndThread)
		{
			rcFilenameSet.insert(TDInsertionElement(strOutputModelName.GetBuffer(),poModelDatabaseItem));
			m_poAssociatedViewer->AddAssetDatabaseItem(poModelDatabaseItem);
		}
		else
		{
			m_poAssociatedViewer->EndDatabaseLock();
			delete poModelDatabaseItem;
			return;
		}

		m_poAssociatedViewer->EndDatabaseLock();
	}
}
//////////////////////////////////////////////////////////////////////////
