/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AssetModelDatabase.h,v 1.0 2009/04/15 11:00:00 PauloZaffari Exp wwwrun $
$DateTime$
Description: Header file for the class implementing IAssetDisplay
						 interface. It declares the headers of the actual used 
						 functions.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/
#ifndef AssetModelDatabse_h__
#define AssetModelDatabse_h__

#pragma once;

#include "Include/IEditorClassFactory.h"
#include "Include/IAssetDisplayDatabase.h"
#include "CryThread.h"

// As CryThread is not an interface, we don't care if we are hiding its methods
// in this plugin.
#pragma warning(push)
#pragma warning(disable:4266)

class CAssetDisplayDatabaseModel: public IAssetDisplayDatabase, public IClassDesc,public CryThread<CAssetDisplayDatabaseModel>
{
	//////////////////////////////////////////////////////////////////////////
	// Types and typedefs
	//////////////////////////////////////////////////////////////////////////

	public:
		typedef std::map<string,IAssetDisplay*>									 TDFilenameToItemMap;
		typedef std::pair<string,IAssetDisplay*>								 TDInsertionElement;


	//////////////////////////////////////////////////////////////////////////
	// Methods
	//////////////////////////////////////////////////////////////////////////
	public:
		CAssetDisplayDatabaseModel();
		~CAssetDisplayDatabaseModel();
		void FreeData(); // Basically, it's an explicit destructor (it means you have to call it yourself).

		//////////////////////////////////////////////////////////////////////////
		// From IAssedDisplayDatabase
		//////////////////////////////////////////////////////////////////////////
		void NotifyShutDown();
		void Lock();
		void Unlock();
		void WaitForThread();

		void Start();
		void Stop();

		// From CryThread as well
		void Run();

		bool SetAssociatedViewer(IAssetViewer* piAssociatedViewer);

		IAssetDisplay*	GetItem(const char* szAddItem);

		const XmlNodeRef&		GetFilterOptionsDescription();
		const XmlNodeRef&		GetDisplayInformationTemplate();

		const char*					GetDatabaseName();
		void								SetVisibleStatus(bool bVisible);
		bool								GetVisibleStatus();

		HWND								GetRenderWindow();
		//////////////////////////////////////////////////////////////////////////

		//////////////////////////////////////////////////////////////////////////
		// From IClassDesc
		//////////////////////////////////////////////////////////////////////////
		virtual ESystemClassID SystemClassID() { return ESYSTEM_CLASS_ASSET_DISPLAY; };
		REFGUID ClassID()
		{
			// {8EA6C7BB-484A-4f84-8E3F-1607A537E6E3}
			static const GUID guid = 
			{ 0x8ea6c7bb, 0x484a, 0x4f84, { 0x8e, 0x3f, 0x16, 0x7, 0xa5, 0x37, 0xe6, 0xe3 } };
			return guid;
		}
		virtual const char* ClassName() { return "Asset Display Texture"; };
		virtual const char* Category() { return "Asset Display"; };
		virtual CRuntimeClass* GetRuntimeClass(){return 0;};
		virtual void ShowAbout() {};

	//////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////
		// from IUnknown - Inherited through IClassDesc.
		//////////////////////////////////////////////////////////////////////////
		HRESULT STDMETHODCALLTYPE QueryInterface( const IID &riid, void **ppvObj ) 
		{ 
			if(riid == __uuidof(IAssetDisplayDatabase)/* && m_pIntegrator*/)
			{
				*ppvObj = this;
				return S_OK;
			}
			return E_NOINTERFACE ; 
		}
		ULONG STDMETHODCALLTYPE AddRef() { return ++m_ref; };
		ULONG STDMETHODCALLTYPE Release() 
		{ 
			if((--m_ref) == 0)
			{
				FreeData();
				delete this;
				return 0; 
			}
			else
				return m_ref;
		}
	protected:
		ULONG m_ref;
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	// Internal class methods
	//////////////////////////////////////////////////////////////////////////
	protected:
		void AddPreLoadedModels(TDFilenameToItemMap& rcFilenameSet);
		void AddDiskModels( TDFilenameToItemMap &rcFilenameSet );

		static LRESULT CALLBACK WindowProc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);

	//////////////////////////////////////////////////////////////////////////
	// Data
	//////////////////////////////////////////////////////////////////////////
	protected:
		bool															m_boMustEndThread;

		bool															m_boNewItemsShouldBeVisible;

		// Used to avoid adding a same texture multiple times.
		// Tip: change this into a map from filename to index to hot update textures.
		TDFilenameToItemMap								m_cKnwonModels;

		IRenderer													*m_renderer;

		CryMutex													m_oAddItemMutex;

		IAssetViewer*											m_poAssociatedViewer;

		XmlNodeRef												m_xmlFilterOptionsDescription;
		XmlNodeRef												m_xmlInformationDisplayTemplate;
};

#pragma warning(pop)

#endif // AssetModelDatabse_h__
