/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AssetModelItem.h,v 1.0 2009/04/15 11:00:00 PauloZaffari Exp wwwrun $
$DateTime$
Description: Header file for the class implementing IAssetDisplayItem
interface. It declares the headers of the actual used 
functions.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/
#ifndef AssetModelItem_h__
#define AssetModelItem_h__

#pragma once

struct  IStatObj;

#include "Include/IAssetDisplay.h"

#include <I3DEngine.h>
//#include <IEntitySystem.h>
//#include <ICryAnimation.h>
//#include <IEntityRenderState.h>
#include <IRenderAuxGeom.h>
//#include <ParticleParams.h>

#include <IShader.h>

class CAssetModelItem: public IAssetDisplay
{
	//////////////////////////////////////////////////////////////////////////
	// Types and typedefs
	//////////////////////////////////////////////////////////////////////////
	public:

	//////////////////////////////////////////////////////////////////////////
	// Methods
	//////////////////////////////////////////////////////////////////////////
	public:
		CAssetModelItem();
		~CAssetModelItem();
		void								FreeData(); // Basically, it's an explicit destructor (it means you have to call it yourself).

		//////////////////////////////////////////////////////////////////////////
		// From IAssetDisplay
		//////////////////////////////////////////////////////////////////////////
		IAssetDisplayDatabase*	GetOwnerDisplayDatabse();
		void										SetOwnerDisplayDatabase(IAssetDisplayDatabase* piOwnerDisplayDatabase);

		bool										GetVisibleStatus() const;
		void										SetVisibleStatus(bool bVisible);

		bool										GetSelectedStatus();
		void										SetSelectedStatus(bool bSelected);

		const XmlNodeRef&				GetFilterOptionsDescription()const;
		bool										FilterAsset(const XmlNodeRef& xmlFilterOptions);
		const XmlNodeRef&				GetAssetInfo();
		const	XmlNodeRef&				GetAssetDisplayInfo();

		//////////////////////////////////////////////////////////////////////////
		// GUI integration and support.
		//////////////////////////////////////////////////////////////////////////
		CRect&									GetDrawingRectangle(CRect& rstDrawingRectangle) const;
		void										SetDrawingRectangle(const CRect& crstDrawingRectangle);

		bool										HitTest(int nX,int nY);
		bool										HitTest(const CRect& roTestRect);

		//////////////////////////////////////////////////////////////////////////
		// Core interface.
		//////////////////////////////////////////////////////////////////////////
		bool										GetCachedStatus();
		bool										CacheAsset(const XmlNodeRef& xmlCacheOptions);
		bool										UnCacheAsset();
		bool										Render(HWND hRenderWindow,const CRect& rstFullViewport,const CRect& rstViewport);
		//////////////////////////////////////////////////////////////////////////
		//
		//////////////////////////////////////////////////////////////////////////
		void										GetFilename(string& rstrFilename) const;
		void										SetFilename(const string& val);

		void										GetExtension(string& rstrExtension) const;
		void										SetExtension(const string& val);

		void 										GetRelativePath(string& rstrRelativePath) const;
		void										SetRelativePath(const string& val);

		bool										GetUsedInLevel() const;
		void										SetUsedInLevel(bool val);

		long long								GetFileSize() const;
		void										SetFileSize(long long val);

		//////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////
		// from IUnknown - Inherited through IClassDesc.
		//////////////////////////////////////////////////////////////////////////
		HRESULT STDMETHODCALLTYPE QueryInterface( const IID &riid, void **ppvObj ) 
		{ 
			if(riid == __uuidof(IAssetDisplay)/* && m_pIntegrator*/)
			{
				*ppvObj = this;
				return S_OK;
			}
			return E_NOINTERFACE ; 
		}
		ULONG STDMETHODCALLTYPE AddRef() { return ++m_ref; };
		ULONG STDMETHODCALLTYPE Release() 
		{ 
			if((--m_ref) == 0)
			{
				FreeData();
				delete this;
				return 0; 
			}
			else
				return m_ref;
		}
protected:
	ULONG m_ref;
	//////////////////////////////////////////////////////////////////////////
	void						SetCameraLookAt( float fRadiusScale,const Vec3& fromDir);
	void						CalculateCameraPosition();

	void						DrawGrid();
	void						SetCamera( CCamera &cam,const CRect &rcViewportRect);

	//////////////////////////////////////////////////////////////////////////
	// Data
	//////////////////////////////////////////////////////////////////////////
protected:
	string	m_strFilename;
	string	m_strExtension;
	string	m_strRelativePath;
	bool    m_boUsedInLevel;

	long long	m_nFileSize;

	bool    m_boVisible;
	CRect		m_oDrawingRectangle;

	bool    m_boIsSelected;

	bool		m_boBitmapIsChached;

	XmlNodeRef	m_xmlAssetInfo;
	XmlNodeRef	m_xmlAssedDisplayInfo;

	bool		m_boMustUpdateAssetInfo;

	IAssetDisplayDatabase*	m_piOwnerDatabase;
	//////////////////////////////////////////////////////////////////////////
	// 
	Vec3				m_camTarget;
	float				m_camRadius;
	CCamera			m_camera;
	AABB				m_aabb;
	IStatObj		*m_object;
	IRenderer		*m_renderer;

	//IReadStream_AutoPtr	m_piStream;

	bool				m_bGrid;
	bool				m_bAxis;

	std::vector<CDLight> m_lights;

	ColorF			m_clearColor;

	bool				m_bRotate;
	float				m_rotateAngle;
	bool				m_bShowObject;
	float				m_fov;
};


#endif // AssetModelItem_h__
