/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: CppCommonHeader.txt,v 1.1 2009/04/15 11:00:00 Paulo Zaffari Exp wwwrun $
$DateTime$
Description:  Application entrypoint for the asset texture plugin from type
asset display.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/


#include "stdafx.h"
#include "platform_impl.h"
#include "Include/IEditorClassFactory.h"
#include "AssetModelPlugin.h"
#include "AssetModelDatabase.h"
#include "Include/IEditorClassFactory.h"

HINSTANCE g_hInstance=0;
ISystem*	g_pSystem(NULL);

//////////////////////////////////////////////////////////////////////////
PLUGIN_API IPlugin * CreatePluginInstance(PLUGIN_INIT_PARAM * pInitParam)
{
	g_pSystem = pInitParam->pIEditorInterface->GetSystem();
	ModuleInitISystem(g_pSystem,"AssetDisplayTexturePlugin");
	pInitParam->pIEditorInterface->GetClassFactory()->RegisterClass(new CAssetDisplayDatabaseModel);
	g_pSystem->GetILog()->Log("Asset Display Texture plug-in: CreatePluginInstance");
	return new CModelAssetPlugin;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Defining memory
size_t CryModuleFree(void* pPointer)
{
	free(pPointer);
	return 0;
}

void* CryModuleMalloc(size_t nSize)
{
	return malloc(nSize);
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved)
{
	//_CrtSetBreakAlloc(74);
	if( fdwReason == DLL_PROCESS_ATTACH )
	{
		g_hInstance = hinstDLL;
	}

	return(TRUE);
}
//////////////////////////////////////////////////////////////////////////