/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AssetTextureDatabase.h,v 1.0 2009/04/15 11:00:00 PauloZaffari Exp wwwrun $
$DateTime$
Description: Header file for the class implementing IAssetDisplay
						 interface. It declares the headers of the actual used 
						 functions.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/
#ifndef AssetTextureDatabse_h__
#define AssetTextureDatabse_h__

#pragma once;

#include "Include/IAssetDisplayDatabase.h"
#include "CryThread.h"

// As CryThread is not an interface, we don't care if we are hiding its methods
// in this plugin.
#pragma warning(push)
#pragma warning(disable:4266)

class CAssetDisplayDatabaseTexture: public IAssetDisplayDatabase, public IClassDesc,public CryThread<CAssetDisplayDatabaseTexture>
{
	//////////////////////////////////////////////////////////////////////////
	// Types and typedefs
	//////////////////////////////////////////////////////////////////////////

	public:
		typedef std::map<string,IAssetDisplay*>									 TDFilenameToItemMap;
		typedef std::pair<string,IAssetDisplay*>								 TDInsertionElement;


	//////////////////////////////////////////////////////////////////////////
	// Methods
	//////////////////////////////////////////////////////////////////////////
	public:
		CAssetDisplayDatabaseTexture();
		~CAssetDisplayDatabaseTexture();
		void FreeData(); // Basically, it's an explicit destructor (it means you have to call it yourself).

		//////////////////////////////////////////////////////////////////////////
		// From IAssedDisplayDatabase
		//////////////////////////////////////////////////////////////////////////
		void NotifyShutDown();
		void Lock();
		void Unlock();
		void WaitForThread();

		void Start();
		void Stop();

		// From CryThread as well
		void Run();

		bool SetAssociatedViewer(IAssetViewer* piAssociatedViewer);

		IAssetDisplay*	GetItem(const char* szAddItem);

		const XmlNodeRef&		GetFilterOptionsDescription();
		const XmlNodeRef&		GetDisplayInformationTemplate();

		const char*					GetDatabaseName();
		void								SetVisibleStatus(bool bVisible);
		bool								GetVisibleStatus();
		//////////////////////////////////////////////////////////////////////////

		//////////////////////////////////////////////////////////////////////////
		// From IClassDesc
		//////////////////////////////////////////////////////////////////////////
		virtual ESystemClassID SystemClassID() { return ESYSTEM_CLASS_ASSET_DISPLAY; };
		REFGUID ClassID()
		{
			// {509EE025-855B-441b-B56E-D4949180968A}
			static const GUID guid = { 0x509ee025, 0x855b, 0x441b, { 0xb5, 0x6e, 0xd4, 0x94, 0x91, 0x80, 0x96, 0x8a } };
			return guid;
		}
		virtual const char* ClassName() { return "Asset Display Texture"; };
		virtual const char* Category() { return "Asset Display"; };
		virtual CRuntimeClass* GetRuntimeClass(){return 0;};
		virtual void ShowAbout() {};

	//////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////
		// from IUnknown - Inherited through IClassDesc.
		//////////////////////////////////////////////////////////////////////////
		HRESULT STDMETHODCALLTYPE QueryInterface( const IID &riid, void **ppvObj ) 
		{ 
			if(riid == __uuidof(IAssetDisplayDatabase)/* && m_pIntegrator*/)
			{
				*ppvObj = this;
				return S_OK;
			}
			return E_NOINTERFACE ; 
		}
		ULONG STDMETHODCALLTYPE AddRef() { return ++m_ref; };
		ULONG STDMETHODCALLTYPE Release() 
		{ 
			if((--m_ref) == 0)
			{
				FreeData();
				delete this;
				return 0; 
			}
			else
				return m_ref;
		}
	protected:
		ULONG m_ref;
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	// Internal class methods
	//////////////////////////////////////////////////////////////////////////
	protected:

	void AddPreLoadedTextures(TDFilenameToItemMap& rcFilenameSet);
	void AddDiskTexture( TDFilenameToItemMap &rcFilenameSet );

	//////////////////////////////////////////////////////////////////////////
	// Data
	//////////////////////////////////////////////////////////////////////////
	protected:
		bool	m_boMustEndThread;

		// Used to avoid adding a same texture multiple times.
		// Tip: change this into a map from filename to index to hot update textures.
		TDFilenameToItemMap								m_cKnwonTextures;


		CryMutex													m_oAddItemMutex;

		IAssetViewer*											m_poAssociatedViewer;

		XmlNodeRef												m_xmlFilterOptionsDescription;
		XmlNodeRef												m_xmlInformationDisplayTemplate;

		bool															m_boNewItemsShouldBeVisible;
};

#pragma warning(pop)

#endif // AssetTextureDatabse_h__
