/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AssetTextureItem.h,v 1.0 2009/04/15 11:00:00 PauloZaffari Exp wwwrun $
$DateTime$
Description: Spirce file for the class implementing IAssetDisplayItem
interface. It declares the headers of the actual used 
functions.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/
#include "StdAfx.h"
#include "AssetTextureItem.h"

// Those files are in the editor.
#include "Util/MemoryBlock.h"
#include "Util/Image.h"
#include "Util/ImageUtil.h"

#include "Util/PathUtil.h"

#include "Include/IAssetDisplayDatabase.h"

#include "ITexture.h"
#include "IRenderer.h"

//#ifdef _DEBUG
//static size_t GetUniqueId()
//{
//	static size_t nUniqueId(0);
//	return ++nUniqueId;
//}
//#endif

//////////////////////////////////////////////////////////////////////////
CAssetTextureItem::CAssetTextureItem():
m_boMustUpdateAssetInfo(true),
m_strFilename(""),
m_strExtension(""),
m_strRelativePath(""),
m_strSurfaceTypeString(""),
m_boUsedInLevel(false),
m_boHasAlphaChannel(false),
m_boIsCubemap(false),
m_nTextureWidth(0),
m_nTextureHeight(0),
m_nMips(0),
m_nFileSize(0),
m_boVisible(true),
m_boBitmapIsChached(false),
m_boIsSelected(false),
m_oDrawingRectangle(0,0,m_nTextureWidth,m_nTextureHeight),
m_piOwnerDatabase(NULL),
m_ref(1),
m_piCachedTexture(NULL)
//#ifdef _DEBUG
//, m_nUniqueId(GetUniqueId())
//#endif//_DEBUG
{
	//#ifdef _DEBUG
	//string strDebugText;
	//strDebugText.Format("Allocated Texture using UID:%d\n",m_nUniqueId);
	//OutputDebugString(strDebugText.c_str());
	//#endif//_DEBUG
}
//////////////////////////////////////////////////////////////////////////
CAssetTextureItem::~CAssetTextureItem()
{
//#ifdef _DEBUG
//	string strDebugText;
//	strDebugText.Format("Deallocated Texture using UID:%d\n",m_nUniqueId);
//	OutputDebugString(strDebugText.c_str());
//#endif//_DEBUG

	FreeData();
}
//////////////////////////////////////////////////////////////////////////
void CAssetTextureItem::FreeData()
{
	if (m_boBitmapIsChached)
	{
		m_piCachedTexture->Release();
		m_boBitmapIsChached=false;
	}	
}
//////////////////////////////////////////////////////////////////////////
IAssetDisplayDatabase*	CAssetTextureItem::GetOwnerDisplayDatabse()
{
	return m_piOwnerDatabase;
}
//////////////////////////////////////////////////////////////////////////
void CAssetTextureItem::SetOwnerDisplayDatabase(IAssetDisplayDatabase* piOwnerDisplayDatabase)
{
	m_piOwnerDatabase=piOwnerDisplayDatabase;
}
//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::GetFilename(string& rstrFilename) const 
{ 
	rstrFilename=m_strFilename; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetFilename(const string& val) 
{ 
	CString strSourceString(val);
	CString strDriveLetter;
	CString strDirectory;
	CString strFilename;
	CString strExtension;
	string	strResultingExtension;

	Path::SplitPath(strSourceString,strDriveLetter,strDirectory,strFilename,strExtension);

	m_strFilename = strFilename; 
	m_strFilename += strExtension;

	if (strExtension.GetLength())
	{
		strResultingExtension=strExtension;
		SetExtension(strResultingExtension.substr(1));
	}	
	SetRelativePath((string)(strDriveLetter+strDirectory));
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::GetExtension(string& rstrExtension) const 
{ 
	rstrExtension=m_strExtension; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetExtension(const string& val) 
{ 
	if (m_strExtension!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}
	m_strExtension = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void 		CAssetTextureItem::GetRelativePath(string& rstrRelativePath) const 
{ 
	rstrRelativePath=m_strRelativePath; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetRelativePath(const string& val) 
{ 
	if (m_strRelativePath!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}

	m_strRelativePath = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::GetSurfaceType(string& rstrSurfaceTypeString) const 
{ 
	rstrSurfaceTypeString=m_strSurfaceTypeString; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetSurfaceType(const string& val) 
{ 
	if (m_strSurfaceTypeString!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}

	m_strSurfaceTypeString = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool		CAssetTextureItem::GetUsedInLevel() const 
{ 
	return m_boUsedInLevel; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetUsedInLevel(bool val) 
{ 
	if (m_boUsedInLevel!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}

	m_boUsedInLevel = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::GetHasAlphaChannelStatus() const
{
	return m_boHasAlphaChannel;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void CAssetTextureItem::SetHasAlphaChannelStatus(bool val)
{
	if (m_boHasAlphaChannel!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}

	m_boHasAlphaChannel=val;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::GetIsCubemap() const
{
	return m_boIsCubemap;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void CAssetTextureItem::SetIsCubeMap(bool boIsCubemap)
{
	if (m_boIsCubemap!=boIsCubemap)
	{
		m_boMustUpdateAssetInfo=true;
	}

	m_boIsCubemap=boIsCubemap;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
int			CAssetTextureItem::GetTextureWidth() const 
{ 
	return m_nTextureWidth; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetTextureWidth(int val) 
{ 
	if (m_nTextureWidth!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}

	m_nTextureWidth = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
int			CAssetTextureItem::GetTextureHeight() const 
{
	return m_nTextureHeight; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetTextureHeight(int val) 
{ 
	if (m_nTextureHeight!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}
	m_nTextureHeight = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
int			CAssetTextureItem::GetMips() const 
{ 
	return m_nMips; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void		CAssetTextureItem::SetMips(int val) 
{ 
	if (m_nMips!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}
	m_nMips = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
long long CAssetTextureItem::GetFileSize() const
{ 
	return m_nFileSize; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void CAssetTextureItem::SetFileSize(long long val )
{
	if (m_nFileSize!=val)
	{
		m_boMustUpdateAssetInfo=true;
	}
	m_nFileSize = val; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool	CAssetTextureItem::GetVisibleStatus() const
{
	return m_boVisible;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void	CAssetTextureItem::SetVisibleStatus(bool val)
{
	m_boVisible=val;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool	CAssetTextureItem::GetSelectedStatus()
{ 
	return m_boIsSelected; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void	CAssetTextureItem::SetSelectedStatus(bool boIsSelected) 
{ 
	m_boIsSelected = boIsSelected; 
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
CRect& CAssetTextureItem::GetDrawingRectangle(CRect& rstDrawingRectangle) const
{ 
	rstDrawingRectangle=m_oDrawingRectangle;
	return rstDrawingRectangle; 
}
//////////////////////////////////////////////////////////////////////////
void	CAssetTextureItem::SetDrawingRectangle(const CRect& crstDrawingRectangle)
{
	m_oDrawingRectangle=crstDrawingRectangle;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::GetCachedStatus()
{
	return m_boBitmapIsChached;
}
//////////////////////////////////////////////////////////////////////////
bool			CAssetTextureItem::CacheAsset(const XmlNodeRef& xmlCacheOptions)
{
	bool bShowOnlyAlpha(false);
	if (xmlCacheOptions)
	{
		if (xmlCacheOptions->isTag("CacheOptions"))
		{
			xmlCacheOptions->getAttr("ShowOnlyAlpha",bShowOnlyAlpha);
		}
	}
	return CacheBitmap(bShowOnlyAlpha);
}
//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::UnCacheAsset()
{
	return UnCacheBitmap();
}
//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::Render(HWND hRenderWindow,const CRect& rstFullViewport,const CRect& rstViewport)
{
	IRenderer*	piRenderer(gEnv->pRenderer);
	int					nX(0),nY(0);
	int					nWidth(0),nHeight(0);

	if (!m_piCachedTexture)
	{
		return false;
	}

	CRect					sRenderRect;

	sRenderRect.left=((float)rstViewport.left/(float)rstFullViewport.Width())*800.0f;
	sRenderRect.top=((float)rstViewport.top/(float)rstFullViewport.Height())*600.0f;
	sRenderRect.right=((float)rstViewport.right/(float)rstFullViewport.Width())*800.0f;
	sRenderRect.bottom=((float)rstViewport.bottom/(float)rstFullViewport.Height())*600.0f;

	piRenderer->Draw2dImage((float)sRenderRect.left,(float)sRenderRect.top,(float)sRenderRect.Width(),(float)sRenderRect.Height(),m_piCachedTexture->GetTextureID(), 0.0f,1.0f,1.0f,0.0f);

	return true;
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::CacheBitmap(bool boShowOnlyAlpha)
{
	if (m_boBitmapIsChached)
	{
		return true;
	}

	// If it was 
	//if (m_boUsedInLevel)
	//{
		IRenderer*	piRenderer(gEnv->pRenderer);

		assert("The texture plugin for the asset browser requires a valid renderer in gEnv"&&piRenderer);

		m_piCachedTexture=piRenderer->EF_LoadTexture((m_strRelativePath+m_strFilename).c_str(),0,eTF_Unknown);
		if (!m_piCachedTexture)
		{
			return false;
		}

		piRenderer->EF_PrecacheResource(m_piCachedTexture,0,0,0,-1);

		
	//}
	//else
	//{
		//	ITexture*		piTexture(NULL);
		//	IRenderer*	piRenderer(NULL);
		//	void *		pBitmapBits(NULL);

		//	piRenderer=gEnv->pRenderer;

		//	piTexture=piRenderer->EF_LoadTexture((m_strRelativePath+m_strFilename).c_str(),FT_DONT_STREAM,eTF_Unknown);
		//	pBitmapBits=piTexture->GetData32(0,0,/*abTextureMatrix*/NULL);

		//	// We failed to cache this bitmap...
		//	if (!pBitmapBits)
		//	{
		//		m_boBitmapIsChached=false;
		//		piTexture->Release();
		//		return false;
		//	}

		//	if (boShowOnlyAlpha)
		//	{
		//		// Here we copy the alpha channel over the other channels making a 
		//		// grayscale bitmap with the alpha channel.
		//		GenerateAlphaMap(pBitmapBits,m_nTextureWidth,m_nTextureHeight);
		//	}

		//	m_oCachedBitmap.CreateBitmap(m_nTextureWidth,m_nTextureHeight,1,32,	pBitmapBits);

		//	piRenderer->EF_Query(EFQ_DeleteMemoryArrayPtr,(INT_PTR)pBitmapBits);

		//	piTexture->Release();
		//}
	//}

	m_boBitmapIsChached=true;

	return m_boBitmapIsChached;
}
//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::UnCacheBitmap()
{
	if (!m_boBitmapIsChached)
	{
		return true;
	}

	m_piCachedTexture->Release();
	m_piCachedTexture=NULL;
	m_boBitmapIsChached=false;

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool	CAssetTextureItem::FilterAsset(const XmlNodeRef& xmlFilterOptions)
{
	bool				boNextVisibleStatus(m_piOwnerDatabase->GetVisibleStatus());
	bool				boCurrentVisibleStatus(m_boVisible);

	bool				boShowDDSOnly(false);
	bool				boShowTIFOnly(false);
	bool				boUsedInLevel(false);
	bool				boHasAlphaChannel(false);

	bool				boShowOnlySpecular(false);
	bool				boShowOnlyBump(false);
	bool				boShowCubemapOnly(false);
	bool				boShowDiffuseOnly(false);

	const char*				szMinimumWidth(NULL);
	int								nMinimumWidth(0);

	const char*				szMaximumWidth(NULL);
	int								nMaximumWidth(0);

	const char*				szMinimumHeight(NULL);
	int								nMinimumHeight(0);

	const char*				szMaximumHeight(NULL);
	int								nMaximumHeight(0);

	const char*				szFilenameFilter(NULL);

	string						strTempString;
	string						strFilenameFilter;

	if (!xmlFilterOptions)
	{
		// If the current visible flag is different of the next, we must
		// set it to the next flag.
		if (boCurrentVisibleStatus!=boNextVisibleStatus)
		{
			m_boVisible=boNextVisibleStatus;
			// Yes, the visible flag changed.
			return true;
		}	
		else
		{
			return false;
		}
	}

	if (xmlFilterOptions->getAttr("Show Only DDS",boShowDDSOnly))
	{
		if (boShowDDSOnly)
		{
			if (m_strExtension.compareNoCase("dds")!=0)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Show Only TIF",boShowTIFOnly))
	{
		if (boShowTIFOnly)
		{
			if (m_strExtension.compareNoCase("tif")!=0)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Used in Level",boUsedInLevel))
	{
		if (boUsedInLevel)
		{
			if (!m_boUsedInLevel)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Has Alpha Channel",boHasAlphaChannel))
	{
		if (boHasAlphaChannel)
		{
			if (!m_boHasAlphaChannel)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Minimum Width",&szMinimumWidth))
	{
		if (stricmp(szMinimumWidth,"Any")!=0)
		{
			nMinimumWidth=atoi(szMinimumWidth);
			if (m_nTextureWidth<nMinimumWidth)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Maximum Width",&szMaximumWidth))
	{
		if (stricmp(szMaximumWidth,"Any")!=0)
		{
			nMaximumWidth=atoi(szMaximumWidth);
			if (m_nTextureWidth>nMaximumWidth)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Minimum Height",&szMinimumHeight))
	{
		if (stricmp(szMinimumHeight,"Any")!=0)
		{
			nMinimumHeight=atoi(szMinimumHeight);
			if (m_nTextureHeight<nMinimumHeight)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Maximum Height",&szMaximumHeight))
	{
		if (stricmp(szMaximumHeight,"Any")!=0)
		{
			nMaximumHeight=atoi(szMaximumHeight);
			if (m_nTextureHeight>nMaximumHeight)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	//// TODO: Martin recommended us not to count on naming conventions...
	//// ... so we should consider discarding this...
	//// If we should display specular textures only...
	if (xmlFilterOptions->getAttr("Show Only Specular",boShowOnlySpecular))
	{
		if (boShowOnlySpecular)
		{
			strTempString=m_strFilename;
			strTempString.MakeLower();
			// If it didn't find "spec" in the name, we assume it's not a specular texture.
			if (strTempString.find("spec")==strTempString.npos)
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Show Only Bump",boShowOnlyBump))
	{
		if (boShowOnlyBump)
		{
			strTempString=m_strFilename;
			strTempString.MakeLower();

			// If it didn't find "spec" in the name, we assume it's not a specular texture.
			if ((strTempString.find("ddn")==strTempString.npos)&&(m_strSurfaceTypeString.compareNoCase("3DC")!=0))
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (xmlFilterOptions->getAttr("Show Cube Map",boShowCubemapOnly))
	{
		if (boShowCubemapOnly)
		{
			if (m_boIsCubemap)
			{
				boNextVisibleStatus=false;
			}
		}
	}


	if (xmlFilterOptions->getAttr("Show Only Diffuse",boShowDiffuseOnly))
	{
		if (boShowDiffuseOnly)
		{
			strTempString=m_strFilename;
			strTempString.MakeLower();

			// If it didn't find "spec" in the name, we assume it's not a specular texture.
			if (strTempString.find("spec")!=strTempString.npos)
			{
				boNextVisibleStatus=false;
			}
			else if (strTempString.find("ddn")!=strTempString.npos)
			{
				boNextVisibleStatus=false;
			}
			else if (m_strSurfaceTypeString.compareNoCase("3DC")!=0) // TODO: improve the bump map testing here.
			{
				boNextVisibleStatus=false;
			}
		}
	}

	// If we have something in the filename filter (and thus we must filter the filenames)...
	if (xmlFilterOptions->getAttr("Filename",&szFilenameFilter))
	{
		strFilenameFilter=szFilenameFilter;
		if (!strFilenameFilter.empty())
		{
			strTempString=m_strRelativePath;
			strTempString+=m_strFilename;
			//strTempString=m_strFilename;
			strTempString.MakeLower();
			strFilenameFilter.MakeLower();

			if (strFilenameFilter[0]!='*')
			{
				strFilenameFilter.insert(0,'*');
			}
			if (strFilenameFilter[strFilenameFilter.size()-1]!='*')
			{
				strFilenameFilter.push_back('*');
			}


			if (!PathUtil::MatchWildcard(strTempString.c_str(),strFilenameFilter.c_str()))
			{
				boNextVisibleStatus=false;
			}
		}
	}

	if (!m_piOwnerDatabase->GetVisibleStatus())
	{
		boNextVisibleStatus=false;
	}

	// If the current visible flag is different of the next, we must
	// set it to the next flag.
	if (boCurrentVisibleStatus!=boNextVisibleStatus)
	{
		m_boVisible=boNextVisibleStatus;
		// In case it's not visible, we will make it's position invalid.
		if (!boNextVisibleStatus)
		{
			m_oDrawingRectangle.SetRect(-65535,-65535,-65535,-65535);
		}

		// Yes, the visible flag changed.
		return true;
	}	

	//No, the visible flag didn't change.
	return false;
}
//////////////////////////////////////////////////////////////////////////
const	XmlNodeRef&  CAssetTextureItem::GetAssetInfo()
{
	if (m_boMustUpdateAssetInfo)
	{
		if (!m_xmlAssetInfo)
		{
			m_xmlAssetInfo=gEnv->pSystem->CreateXmlNode("AssetInformation");
		}
		m_xmlAssetInfo->setAttr("RelativePath",m_strRelativePath);
		m_xmlAssetInfo->setAttr("Filename",m_strFilename);
		m_xmlAssetInfo->setAttr("Extension",m_strExtension);
		m_xmlAssetInfo->setAttr("SurfaceType",m_strSurfaceTypeString);
		m_xmlAssetInfo->setAttr("FileSize",m_nFileSize);
		m_xmlAssetInfo->setAttr("Mips",m_nMips);
		m_xmlAssetInfo->setAttr("Width",m_nTextureWidth);
		m_xmlAssetInfo->setAttr("Height",m_nTextureHeight);
		m_xmlAssetInfo->setAttr("FileSize",m_nFileSize);
		m_xmlAssetInfo->setAttr("UsedInLevel",m_boUsedInLevel);
		m_xmlAssetInfo->setAttr("HasAlphaChannel",m_boHasAlphaChannel);
		m_xmlAssetInfo->setAttr("IsCubeMap",m_boIsCubemap);
		m_boMustUpdateAssetInfo=false;
	}
	return m_xmlAssetInfo;
}
//////////////////////////////////////////////////////////////////////////
const			XmlNodeRef&  CAssetTextureItem::GetAssetDisplayInfo()
{
	if (!m_xmlAssedDisplayInfo)
	{
		// As the XML node is ref counted, the old asset info will be be released
		// just as needed.
		XmlNodeRef	xmlCurrentNode;
		string			strResolutionString;

		m_xmlAssedDisplayInfo=gEnv->pSystem->CreateXmlNode("AssetDisplayInformation");

		xmlCurrentNode=m_xmlAssedDisplayInfo->newChild("Filename");
		xmlCurrentNode->setAttr("DisplayName","Filename:");
		xmlCurrentNode->setAttr("MultilineDisplay",true);
		xmlCurrentNode->setAttr("DisplayValue",m_strFilename);

		xmlCurrentNode=m_xmlAssedDisplayInfo->newChild("SurfaceType");
		xmlCurrentNode->setAttr("DisplayName","Type:");
		xmlCurrentNode->setAttr("MultilineDisplay",false);
		xmlCurrentNode->setAttr("DisplayValue",m_strSurfaceTypeString);

		xmlCurrentNode=m_xmlAssedDisplayInfo->newChild("Mips");
		xmlCurrentNode->setAttr("DisplayName","Mips:");
		xmlCurrentNode->setAttr("MultilineDisplay",false);
		xmlCurrentNode->setAttr("DisplayValue",m_nMips);

		xmlCurrentNode=m_xmlAssedDisplayInfo->newChild("Filesize");
		xmlCurrentNode->setAttr("DisplayName","Size:");
		xmlCurrentNode->setAttr("MultilineDisplay",false);
		xmlCurrentNode->setAttr("ValueType","int");
		xmlCurrentNode->setAttr("MaySum",true);
		xmlCurrentNode->setAttr("DisplayValue",m_nFileSize);

		strResolutionString.Format("%d X %d",m_nTextureWidth,m_nTextureHeight);

		xmlCurrentNode=m_xmlAssedDisplayInfo->newChild("Resolution");
		xmlCurrentNode->setAttr("DisplayName","Resolution:");
		xmlCurrentNode->setAttr("MultilineDisplay",false);
		xmlCurrentNode->setAttr("DisplayValue",strResolutionString);
	}
	return m_xmlAssedDisplayInfo;
}
//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::HitTest(int nX,int nY)
{
	CRect oTestRect(nX,nY,nX,nY);
	CRect oIntersection;

	if (
		((nX>=m_oDrawingRectangle.left)&&(nX<=m_oDrawingRectangle.right))
		&&
		((nY>=m_oDrawingRectangle.top)&&(nY<=m_oDrawingRectangle.bottom))
		)
	{
		return true;
	}
	else
	{
		return false;
	}
}
//////////////////////////////////////////////////////////////////////////
bool CAssetTextureItem::HitTest(const CRect& roTestRect)
{
	CRect oIntersection;
	return (oIntersection.IntersectRect(m_oDrawingRectangle,roTestRect)!=FALSE);
}
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
void CAssetTextureItem::GenerateAlphaMap(void *pBitmapBits,int nWidth,int nHeight)
{
	unsigned char*	uchTexture((unsigned char*)pBitmapBits);
	unsigned char   uchAlphaByte(0);
	int							nCurrentX(0),nCurrentY(0);
	int             nCurrentOfsset(0);

	if (!uchTexture)
	{
		return;
	}

	for (nCurrentX=0;nCurrentX<nWidth;++nCurrentX)
	{
		for (nCurrentY=0;nCurrentY<nHeight;++nCurrentY)
		{
			// As we know our format is 32 bit, we also know it is 4 times unsinged char size.
			// As the format is RGBA, the last byte is the alpha byte, and so is the one we 
			// have to propagate to all other channels.
			nCurrentOfsset=nCurrentX*4+nCurrentY*nWidth*4;
			uchAlphaByte=uchTexture[nCurrentOfsset+3];
			uchTexture[nCurrentOfsset+0]=uchAlphaByte;
			uchTexture[nCurrentOfsset+1]=uchAlphaByte;
			uchTexture[nCurrentOfsset+2]=uchAlphaByte;
		}
	}
}
//////////////////////////////////////////////////////////////////////////