/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AssetTextureItem.h,v 1.0 2009/04/15 11:00:00 PauloZaffari Exp wwwrun $
$DateTime$
Description: Header file for the class implementing IAssetDisplayItem
interface. It declares the headers of the actual used 
functions.
-------------------------------------------------------------------------
History:
- 15:04:2009   11:00 : Created by Paulo Zaffari

*************************************************************************/
#ifndef AssetTextureItem_h__
#define AssetTextureItem_h__

#pragma once

class ITexture;

#include "Include/IAssetDisplay.h"

class CAssetTextureItem: public IAssetDisplay
{
	//////////////////////////////////////////////////////////////////////////
	// Types and typedefs
	//////////////////////////////////////////////////////////////////////////
	public:

	//////////////////////////////////////////////////////////////////////////
	// Methods
	//////////////////////////////////////////////////////////////////////////
	public:
		CAssetTextureItem();
		~CAssetTextureItem();
		void								FreeData(); // Basically, it's an explicit destructor (it means you have to call it yourself).


		//////////////////////////////////////////////////////////////////////////
		// From IAssetDisplay
		//////////////////////////////////////////////////////////////////////////
		IAssetDisplayDatabase*	GetOwnerDisplayDatabse();
		void SetOwnerDisplayDatabase(IAssetDisplayDatabase* piOwnerDisplayDatabase);

		bool								GetVisibleStatus() const;
		void								SetVisibleStatus(bool bVisible);

		bool								GetSelectedStatus();
		void								SetSelectedStatus(bool bSelected);

		const XmlNodeRef&		GetFilterOptionsDescription()const;
		bool								FilterAsset(const XmlNodeRef& xmlFilterOptions);
		const XmlNodeRef&				GetAssetInfo();
		const			XmlNodeRef&		GetAssetDisplayInfo();

		//////////////////////////////////////////////////////////////////////////
		// GUI integration and support.
		//////////////////////////////////////////////////////////////////////////
		CRect&							GetDrawingRectangle(CRect& rstDrawingRectangle) const;
		void								SetDrawingRectangle(const CRect& crstDrawingRectangle);

		bool								HitTest(int nX,int nY);
		bool								HitTest(const CRect& roTestRect);

		//////////////////////////////////////////////////////////////////////////
		// Core interface.
		//////////////////////////////////////////////////////////////////////////
		bool								GetCachedStatus();
		bool								CacheAsset(const XmlNodeRef& xmlCacheOptions);
		bool								UnCacheAsset();
		bool								Render(HWND hRenderWindow,const CRect& rstFullViewport,const CRect& rstViewport);

		//////////////////////////////////////////////////////////////////////////
		// Internal sutff, not part of the interfaces.
		bool								CacheBitmap(bool boShowOnlyAlpha);
		bool								UnCacheBitmap();
		//////////////////////////////////////////////////////////////////////////

		//////////////////////////////////////////////////////////////////////////

		//////////////////////////////////////////////////////////////////////////
		//
		//////////////////////////////////////////////////////////////////////////
		void								GetFilename(string& rstrFilename) const;
		void								SetFilename(const string& val);

		void								GetExtension(string& rstrExtension) const;
		void								SetExtension(const string& val);

		void 								GetRelativePath(string& rstrRelativePath) const;
		void								SetRelativePath(const string& val);

		void								GetSurfaceType(string& rstrSurfaceTypeString) const;
		void								SetSurfaceType(const string& val);

		bool								GetUsedInLevel() const;
		void								SetUsedInLevel(bool val);

		bool								GetHasAlphaChannelStatus() const;
		void								SetHasAlphaChannelStatus(bool val);

		bool								GetIsCubemap() const;
		void								SetIsCubeMap(bool boIsCubemap);

		int									GetTextureWidth() const;
		void								SetTextureWidth(int val);

		int									GetTextureHeight() const;
		void								SetTextureHeight(int val);

		int									GetMips() const;
		void								SetMips(int val);

		long long						GetFileSize() const;
		void								SetFileSize(long long val);

	//////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////
		// from IUnknown - Inherited through IClassDesc.
		//////////////////////////////////////////////////////////////////////////
		HRESULT STDMETHODCALLTYPE QueryInterface( const IID &riid, void **ppvObj ) 
		{ 
			if(riid == __uuidof(IAssetDisplay)/* && m_pIntegrator*/)
			{
				*ppvObj = this;
				return S_OK;
			}
			return E_NOINTERFACE ; 
		}
		ULONG STDMETHODCALLTYPE AddRef() { return ++m_ref; };
		ULONG STDMETHODCALLTYPE Release() 
		{ 
			if((--m_ref) == 0)
			{
				FreeData();
				delete this;
				return 0; 
			}
			else
				return m_ref;
		}
protected:
	ULONG m_ref;
	//////////////////////////////////////////////////////////////////////////



	void    GenerateAlphaMap(void *pBitmapBits,int nWidth,int nHeight);

	//////////////////////////////////////////////////////////////////////////
	// Data
	//////////////////////////////////////////////////////////////////////////
protected:
	string	m_strFilename;
	string	m_strExtension;
	string	m_strRelativePath;
	string  m_strSurfaceTypeString;
	bool    m_boUsedInLevel;
	bool    m_boHasAlphaChannel;
	bool    m_boIsCubemap;

	int			m_nTextureWidth;
	int			m_nTextureHeight;			
	int			m_nMips;
	unsigned long long	m_nFileSize;

	bool    m_boVisible;
	CRect		m_oDrawingRectangle;

	//CBitmap	m_oCachedBitmap;

	bool    m_boIsSelected;

	bool		m_boBitmapIsChached;

	XmlNodeRef	m_xmlAssetInfo;
	XmlNodeRef	m_xmlAssedDisplayInfo;

	bool				m_boMustUpdateAssetInfo;

	ITexture		*m_piCachedTexture;

	IAssetDisplayDatabase*	m_piOwnerDatabase;

//#ifdef _DEBUG
//	size_t				m_nUniqueId;
//#endif//_DEBUG	
};


#endif // AssetTextureItem_h__