/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: CppCommonHeader.txt,v 1.1 2008/08/04 16:26:42 Paulo Zaffari Exp wwwrun $
$DateTime$
Description:  Application entrypoint for the XBOX360 plugin from type
conectivity.
-------------------------------------------------------------------------
History:
- 04:08:2008   16:26 : Created by Paulo Zaffari

*************************************************************************/


#include "stdafx.h"
#include "platform_impl.h"
#include "Include/IEditorClassFactory.h"
#include "Include/IConsoleConnectivity.h"
#include "XBOX360Plugin.h"
#include "XBOX360ConsoleConnectivity.h"
#include "Include/IEditorClassFactory.h"

#include "delayimp.h"


HINSTANCE g_hInstance=0;
ISystem*	g_pSystem(NULL);

static bool DelayLoadDll()
{
	DWORD								dwBufferSize(0);
	std::vector<char>		cchEnvironmentBuffer;
	std::string					strDLLFilename;

	dwBufferSize=GetEnvironmentVariable("XEDK",NULL,0);
	cchEnvironmentBuffer.resize(dwBufferSize+1,0);

	dwBufferSize=GetEnvironmentVariable("XEDK",&cchEnvironmentBuffer.front(),dwBufferSize+1);
	strDLLFilename=&cchEnvironmentBuffer.front();

#if defined(_WIN32)
	strDLLFilename+="\\bin\\win32\\";
#elif defined(_WIN64)
	strDLLFilename+="\\bin\\x64\\";
#else 
	// Not defined.
	_debugbreak();
	return false;
#endif 

	//dwBufferSize=GetCurrentDirectory(0,NULL);
	//cchEnvironmentBuffer.resize(dwBufferSize+1,0);
	//GetCurrentDirectory(dwBufferSize+1,&cchEnvironmentBuffer.front());

	////  For the f! Dll loading stuff work...
	//SetCurrentDirectory(strDLLFilename.c_str());
	//try
	//{
		if (FAILED(__HrLoadAllImportsForDll((char *)"xbdm.dll",(char *)strDLLFilename.c_str()))) 
		{
//			SetCurrentDirectory(&cchEnvironmentBuffer.front());

			return false;
		}
	//}
	//catch (...)
	//{
	//	SetCurrentDirectory(&cchEnvironmentBuffer.front());

	//	return false;
	//}

	//SetCurrentDirectory(&cchEnvironmentBuffer.front());
	return true;
}

PLUGIN_API IPlugin * CreatePluginInstance(PLUGIN_INIT_PARAM * pInitParam)
{
	g_pSystem = pInitParam->pIEditorInterface->GetSystem();
	ModuleInitISystem(g_pSystem,"XBOX360ConnectivityPlugin");
	pInitParam->pIEditorInterface->GetClassFactory()->RegisterClass(new CXBOX360ConnectivityPlugin);
	g_pSystem->GetILog()->Log("XBOX360 connectivity plug-in: CreatePluginInstance");
	return new CXBOX360Plugin;
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved)
{
	if( fdwReason == DLL_PROCESS_ATTACH )
	{
		g_hInstance = hinstDLL;

		if (!DelayLoadDll())
		{
			return FALSE;
		}
	}

	return(TRUE);
}
