/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: XBOX360.h,v 1.0 2008/08/04 16:54:31 PauloZaffari Exp wwwrun $
$DateTime$
Description: Header file for the class implementing IConsoleConnectivity
						 interface. It declares the headers of the actual used 
						 functions.
-------------------------------------------------------------------------
History:
- 04:08:2008   16:54 : Created by Paulo Zaffari

*************************************************************************/
#ifndef XBOX360Connectivity_h__
#define XBOX360Connectivity_h__

#pragma once;

class CXBOX360ConnectivityPlugin: public IConsoleConnectivity, public IClassDesc
{
	public:
		CXBOX360ConnectivityPlugin();
		void FreeData(); // Basically, it's an explicit destructor (it means you have to call it yourself.

		//////////////////////////////////////////////////////////////////////////
		// From IConsoleConnectivity
		//////////////////////////////////////////////////////////////////////////
		bool IsConnectedToConsole();

		bool SendFile(const char* szLocalFileName,const char* szRemoteFilename);

		bool NotifyFileChange(const char* szRemoteFilename);

		bool GetConsoleAddress(DWORD* pdwConsoleAddressPlaceholder);
		//////////////////////////////////////////////////////////////////////////
		// From IClassDesc
		//////////////////////////////////////////////////////////////////////////
		virtual ESystemClassID SystemClassID() { return ESYSTEM_CLASS_CONSOLE_CONNECTIVITY; };
		REFGUID ClassID()
		{
			// {C7F5B153-B2F5-4b0b-8FA3-7CF7C7B07FF2}
			static const GUID guid = { 0xc7f5b153, 0xb2f5, 0x4b0b, { 0x8f, 0xa3, 0x7c, 0xf7, 0xc7, 0xb0, 0x7f, 0xf2 } };

			return guid;
		}
		virtual const char* ClassName() { return "XBOX Console Connectivity"; };
		virtual const char* Category() { return "Console Connectivity"; };
		virtual CRuntimeClass* GetRuntimeClass(){return 0;};
		virtual void ShowAbout() {};

		//////////////////////////////////////////////////////////////////////////
		// from IUnknown - Inherited through IClassDesc.
		//////////////////////////////////////////////////////////////////////////
		HRESULT STDMETHODCALLTYPE QueryInterface( const IID &riid, void **ppvObj ) 
		{ 
			if(riid == __uuidof(IConsoleConnectivity)/* && m_pIntegrator*/)
			{
				*ppvObj = this;
				return S_OK;
			}
			return E_NOINTERFACE ; 
		}
		ULONG STDMETHODCALLTYPE AddRef() { return ++m_ref; };
		ULONG STDMETHODCALLTYPE Release() 
		{ 
			if((--m_ref) == 0)
			{
				FreeData();
				delete this;
				return 0; 
			}
			else
				return m_ref;
		}
	protected:
		bool CreateDirectoryQueue(const string& rstrDrive,const std::vector<string>& rcstrDirectoryQueue);


		ULONG m_ref;

};

#endif // XBOX360Connectivity_h__
