#include "stdafx.h"

#include "Xbdm.h"

#include "Include/IConsoleConnectivity.h"
#include "Include/IEditorClassFactory.h"
#include "XBOX360ConsoleConnectivity.h"

#include <Winsock2.h>

namespace Path
{
	//////////////////////////////////////////////////////////////////////////
	void ConvertSlashToBackSlash(string& rstrStringToConvert)
	{
		size_t nCount(0);
		size_t nTotal(0);

		nTotal=rstrStringToConvert.size();
		for (nCount=0;nCount<nTotal;++nCount)
		{
			if (rstrStringToConvert[nCount]=='/')
			{
				rstrStringToConvert.replace(nCount,1,1,'\\');
			}
		}	
	}
	//////////////////////////////////////////////////////////////////////////
	void ConvertBackSlashToSlash(string& rstrStringToConvert)
	{
		size_t nCount(0);
		size_t nTotal(0);

		nTotal=rstrStringToConvert.size();
		for (nCount=0;nCount<nTotal;++nCount)
		{
			if (rstrStringToConvert[nCount]=='\\')
			{
				rstrStringToConvert.replace(nCount,1,1,'/');
			}
		}	
	}
	//////////////////////////////////////////////////////////////////////////
	void SplitPath(const string& rstrFullPathFilename,string& rstrDriveLetter,string& rstrDirectory,string& rstrFilename,string& rstrExtension)
	{
		char*				szPath((char*)rstrFullPathFilename.c_str());
		char*				pchLastPosition(szPath);
		char*       pchCurrentPosition(szPath);
		char*				pchAuxPosition(szPath);

		// Directory names or filenames containing ":" are invalid, so we can assume if there is a :
		// it will be the drive name.
		pchCurrentPosition=strchr(pchLastPosition,':');
		if (pchCurrentPosition==NULL)
		{
			rstrDriveLetter="";
		}
		else
		{
			rstrDriveLetter.assign(pchLastPosition,pchCurrentPosition+1);
			pchLastPosition=pchCurrentPosition+1;
		}

		pchCurrentPosition=strrchr(pchLastPosition,'\\');
		pchAuxPosition=strrchr(pchLastPosition,'/');
		if ((pchCurrentPosition==NULL)&&(pchAuxPosition==NULL))
		{
			rstrDirectory="";
		}
		else
		{
			// Since NULL is < valid pointer, so this will work.
			if (pchAuxPosition>pchCurrentPosition)
			{
				pchCurrentPosition=pchAuxPosition;
			}
			rstrDirectory.assign(pchLastPosition,pchCurrentPosition+1);
			pchLastPosition=pchCurrentPosition+1;
		}

		pchCurrentPosition=strrchr(pchLastPosition,'.');
		if (pchCurrentPosition==NULL)
		{
			rstrExtension="";
			rstrFilename.assign(pchLastPosition);
		}
		else
		{
			rstrExtension.assign(pchCurrentPosition);
			rstrFilename.assign(pchLastPosition,pchCurrentPosition);
		}	
	}
	//////////////////////////////////////////////////////////////////////////
	void GetDirectoryQueue(const string& rstrSourceDirectory,std::vector<string>& rcstrDirectoryTree)
	{
		string						strCurrentDirectoryName;
		const char*				szSourceDirectory(rstrSourceDirectory.c_str());
		const char*				pchCurrentPosition(szSourceDirectory);
		const char*				pchLastPosition(szSourceDirectory);
		const char*				pchAuxPosition(szSourceDirectory);

		rcstrDirectoryTree.clear();

		if (rstrSourceDirectory.empty())
		{
			return;
		}

		// It removes as many slashes the path has in its start...
		// MAYBE and just maybe we should consider paths starting with
		// more than 2 slashes invalid paths...
		while ((*pchLastPosition=='\\')||(*pchLastPosition=='/'))
		{
			++pchLastPosition;
			++pchCurrentPosition;
		}

		do 
		{
			pchCurrentPosition=strpbrk(pchLastPosition,"\\/");
			if (pchCurrentPosition==NULL)
			{
				break;
			}
			strCurrentDirectoryName.assign(pchLastPosition,pchCurrentPosition);
			pchLastPosition=pchCurrentPosition+1;
			// Again, here we are skipping as many consecutive slashes.
			while ((*pchLastPosition=='\\')||(*pchLastPosition=='/'))
			{
				++pchLastPosition;
			}


			rcstrDirectoryTree.push_back(strCurrentDirectoryName);

		} while (true);
	}
}


CXBOX360ConnectivityPlugin::CXBOX360ConnectivityPlugin()
{
	
}

void CXBOX360ConnectivityPlugin::FreeData()
{

}

bool CXBOX360ConnectivityPlugin::IsConnectedToConsole()
{
	HRESULT						hCurrentResult(XBDM_NOERR);
	DM_SYSTEM_INFO		stSystemInfo;

	memset(&stSystemInfo,0,sizeof(DM_SYSTEM_INFO));
	stSystemInfo.SizeOfStruct=sizeof(DM_SYSTEM_INFO);

	hCurrentResult=DmGetSystemInfo(&stSystemInfo);


	return (hCurrentResult==XBDM_NOERR);
}

bool CXBOX360ConnectivityPlugin::SendFile(const char* szLocalFileName,const char* szRemoteFilename)
{
	string									strDrive,strPath,strFilename,strExtension;
	string									strRemoteFilename(szRemoteFilename);
	std::vector<string>			cstrPathStack;

	Path::SplitPath(szRemoteFilename,strDrive,strPath,strFilename,strExtension);
	Path::GetDirectoryQueue(strPath,cstrPathStack);
	CreateDirectoryQueue(strDrive,cstrPathStack);

	Path::ConvertSlashToBackSlash(strRemoteFilename);

	HRESULT hOperationResult=DmSendFile(szLocalFileName,strRemoteFilename.c_str());

	if (hOperationResult==XBDM_NOERR)
	{
		return true;
	}

	return false;
}

bool CXBOX360ConnectivityPlugin::NotifyFileChange(const char* szRemoteFilename)
{
	PDM_CONNECTION	stConnection;
	HRESULT         hOperationResult(S_OK);
	string					strCommand("NotifyFileChange");
	string					strRemoteFilename(szRemoteFilename);
	bool						boSendCommandResult(true);

	hOperationResult=DmOpenConnection(&stConnection);
	if (hOperationResult!=XBDM_NOERR)
	{
		return false;
	}

	// This line seems to be failing for some reason...
	// Even having created a Threaded command processor with DmRegisterThreadedCommandProcessor,
	// It returns an error code XBDM_NOTHREAD... there seems to be a problem here...
	hOperationResult=DmDedicateConnection(stConnection,strCommand.c_str());
	if (hOperationResult!=XBDM_NOERR)
	{
	//	DmCloseConnection(stConnection);
//		return false;
	}

	Path::ConvertSlashToBackSlash(strRemoteFilename);

	strCommand+="!";
	strCommand+=strRemoteFilename;
	hOperationResult=DmSendCommand(stConnection,strCommand.c_str(),NULL,NULL);
	if (hOperationResult!=XBDM_NOERR)
	{
		boSendCommandResult=false;
	}
	DmCloseConnection(stConnection);

	return true;
}

bool CXBOX360ConnectivityPlugin::GetConsoleAddress(DWORD* pdwConsoleAddressPlaceholder)
{
	HRESULT hResult(XBDM_NOERR );
	bool		boReturnValue(false);

	if (!pdwConsoleAddressPlaceholder)
	{
		return false;
	}
	hResult=DmGetAltAddress(pdwConsoleAddressPlaceholder);

	boReturnValue=(hResult==XBDM_NOERR);

	if (boReturnValue)
	{
		*pdwConsoleAddressPlaceholder=ntohl(*pdwConsoleAddressPlaceholder);
	}

	return boReturnValue;
}

bool CXBOX360ConnectivityPlugin::CreateDirectoryQueue(const string& rstrDrive,const std::vector<string>& rcstrDirectoryQueue)
{
	string strCurrentDirectory(rstrDrive);
	HRESULT			hDirectoryResult(S_OK);

	strCurrentDirectory+="\\";

	size_t nTotal(rcstrDirectoryQueue.size());
	for (size_t nCount=0;nCount<nTotal;++nCount)
	{
		strCurrentDirectory+=rcstrDirectoryQueue[nCount];
		hDirectoryResult=DmMkdir(strCurrentDirectory.c_str());
		if (hDirectoryResult==XBDM_ALREADYEXISTS)
		{
			strCurrentDirectory+="\\";
			continue;
		}
		else if (hDirectoryResult!=XBDM_NOERR)
		{
			return false;
		}
		strCurrentDirectory+="\\";
	}

	return true;
}
