#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Solution makefile for CryEngine GameSkeleton sample.

GameVersion := GameSkeleton
GameDll_CODE := $(GameVersion)/GameDll

Editor_CODE := Sandbox/Editor

Cry3DEngine_CODE := CryEngine/Cry3DEngine
CryAISystem_CODE := CryEngine/CryAISystem
CryAISystem2_CODE := CryEngine/CryAISystem2
CryAnimation_CODE := CryEngine/CryAnimation
CryCommon_CODE := CryEngine/CryCommon
CryEntitySystem_CODE := CryEngine/CryEntitySystem
CryFont_CODE := CryEngine/CryFont
CryInput_CODE := CryEngine/CryInput
CryMovie_CODE := CryEngine/CryMovie
CryNetwork_CODE := CryEngine/CryNetwork
CryPhysics_CODE := CryEngine/CryPhysics
CryScriptSystem_CODE := CryEngine/CryScriptSystem
CrySoundSystem_CODE := CryEngine/CrySoundSystem
CrySystem_CODE := CryEngine/CrySystem
XRenderD3D10_CODE := CryEngine/RenderDll/XRenderD3D9
XRenderNULL_CODE := CryEngine/RenderDll/XRenderNULL

Launcher_CODE := $(GameVersion)/Launcher
LinuxLauncher_CODE := $(GameVersion)/LinuxLauncher
PS3Launcher_CODE := $(GameVersion)/PS3Launcher
XenonLauncher_CODE := $(GameVersion)/XenonLauncher

ifneq ($(BUILD_WITH_PS3_SDK),1)
	PROJECTS_CryEngine := \
		Cry3DEngine \
		CryAISystem \
		CryAnimation \
		CryCommon \
		CryEntitySystem \
		CryFont \
		CryInput \
		CryMovie \
		CryNetwork \
		CryPhysics \
		CryScriptSystem \
		CrySoundSystem \
		CrySystem

	ifeq ($(OPTION_DEDICATED),1)
	 PROJECTS_Renderer := XRenderNULL
	else # OPTION_DEDICATED
	 ifeq ($(ARCH_OS),Linux)
	  PROJECTS_Renderer := XRenderNULL XRenderD3D10
	 endif
	 ifeq ($(ARCH_OS),PS3)
	  #PROJECTS_Renderer := XRenderNULL
	  PROJECTS_Renderer := XRenderD3D10
	 endif
	endif # OPTION_DEDICATED else

	ifdef OPTION_RENDERER
	 ifneq ($(OPTION_RENDERER),)
	  PROJECTS_Renderer := $(OPTION_RENDERER)
	 endif
	endif

	ifeq ($(OPTION_EDITOR),1)
	 PROJECTS_Editor := Editor
	else
	 PROJECTS_Editor :=
	endif
	
else
	PROJECTS_CryEngine := 
	PROJECTS_Renderer := 
endif

ifeq ($(ARCH_OS),Win32)
 PROJECTS_Launcher := Launcher
 OPTION_EDITOR ?= 1
endif
ifeq ($(ARCH_OS),Win64)
 PROJECTS_Launcher := Launcher
 OPTION_EDITOR ?= 1
endif
ifeq ($(ARCH_OS),Linux)
 PROJECTS_Launcher := LinuxLauncher
 OPTION_EDITOR := 0
endif
ifeq ($(ARCH_OS),PS3)
 PROJECTS_Launcher := PS3Launcher
 OPTION_EDITOR := 0
endif

ifeq ($(OPTION_EDITOR),1)
 PROJECTS_Editor := Editor
else
 PROJECTS_Editor := 
endif

ifeq ($(ARCH_OS),PS3)
 PROJECTS_Launcher := PS3Launcher
 SOLUTION_CPPFLAGS += -DPS3_CRYENGINE
 SOLUTION_CPPFLAGS_SCAN += -DPS3_CRYENGINE  
endif
	
ifeq ($(GENERATE_PS3_SDK),1)	
	PROJECTS_Game := 
else	
	PROJECTS_Game := GameDll
endif

PROJECTS := $(PROJECTS_Game) \
	$(PROJECTS_CryEngine) \
	$(PROJECTS_Editor) \
	$(PROJECTS_Launcher) \
	$(PROJECTS_Renderer)

define launcher_DEPS
$(1)_DEPS := $(PROJECTS_CryEngine) $(PROJECTS_Game) $(PROJECTS_Renderer)
endef
$(foreach launcher,$(PROJECTS_Launcher),\
	$(eval $(call launcher_DEPS,$(launcher))))

DEFAULT_PROJECT := $(firstword $(PROJECTS_Launcher))

# SPU Job related settings are listed below 
OPTION_CRYCG_SYSTEM_HEADERS := $(MAKE_ROOT)/Tools/crycg/yvals.h $(MAKE_ROOT)/Tools/crycg/predefs.h

# compiler settings for the DXPSThread SPU 
XFLAGS_SPU_JOB_MAX_SPEED = -O3 -fgcse-after-reload\
		-fgcse-las -fgcse-sm -fgcse-lm -fsched2-use-superblocks\
		-ftracer -fsplit-ivs-in-unroller\
		-fvariable-expansion-in-unroller -fomit-frame-pointer

PROJECT_XFLAGS_SPUJOB_IsBoxOccluded = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_MixStreamsKernel = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_DXPSThreadSPU = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_DXPSRasterize = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_WaterUpdate = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_SkyUpdate = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_ProcessForwardKinematics = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPUJOB_zlib_inflate = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
SPUJOB_LDFLAGS_zlib_inflate = -ledgezlib

PROJECT_XFLAGS_SPUJOBGEN_FLAGS_DXPSThreadSPU=DisableCTor ProfileSectionThreshold:1000000 CacheConfig.Size:4k

PROJECT_XFLAGS_SPUJOBGEN_FLAGS_Rope=DisableCTor CacheConfig.Size:4k
PROJECT_XFLAGS_SPUJOB_Rope=-O2 -fomit-frame-pointer -fstrict-aliasing
PROJECT_XFLAGS_SPU_DEFAULTDOMAIN_Rope=LOCAL
PROJECT_XFLAGS_SPU_PAGEMODE_Rope=File
PROJECT_XFLAGS_SPU_INITIAL_PAGESIZE_Rope=1
PROJECT_XFLAGS_SPU_PAGESIZE_Rope=44000

# scan/generate and compile settings for the CryPhysics RB_Intersect Job
PROJECT_XFLAGS_SPU_DEFAULTDOMAIN_RB_Intersect=LOCAL
PROJECT_XFLAGS_SPU_PAGEMODE_RB_Intersect=File
PROJECT_XFLAGS_SPU_INITIAL_PAGESIZE_RB_Intersect=2
PROJECT_XFLAGS_SPUJOBGEN_FLAGS_RB_Intersect=DisableCTor CacheConfig.Size:4k
PROJECT_XFLAGS_SPUJOB_RB_Intersect=-O2 -fomit-frame-pointer -fstrict-aliasing
PROJECT_XFLAGS_SPU_PAGESIZE_RB_Intersect=38912

#PROJECT_XFLAGS_SPUJOBGEN_FLAGS_RB_Solver=CacheConfig.Size:0
PROJECT_XFLAGS_SPUJOB_RB_Solver=$(XFLAGS_SPU_JOB_MAX_SPEED) -fstrict-aliasing

# scan/generate and compile settings for the CryPhysics Cloth job
PROJECT_XFLAGS_SPU_DEFAULTDOMAIN_Cloth=LOCAL
PROJECT_XFLAGS_SPUJOB_Cloth = -Os -fstrict-aliasing
PROJECT_XFLAGS_SPUJOBGEN_FLAGS_Cloth=DisableCTor CacheConfig.Size:4k

PROJECT_XFLAGS_SPUJOB_ProcessAnimationUpdate = -Os -ffast-math -fomit-frame-pointer

#PROJECT_XFLAGS_SPUJOB_CommandBufferExecute = -Os -ffast-math -fomit-frame-pointer
PROJECT_XFLAGS_SPUJOB_CommandBufferExecute = $(XFLAGS_SPU_JOB_MAX_SPEED) -ffast-math
PROJECT_XFLAGS_SPU_PAGEMODE_CommandBufferExecute=File
PROJECT_XFLAGS_SPU_INITIAL_PAGESIZE_CommandBufferExecute=2
PROJECT_XFLAGS_SPU_PAGESIZE_CommandBufferExecute=64000
PROJECT_XFLAGS_SPU_DISTRIBUTION_STRATEGY_CommandBufferExecute=manual
PROJECT_XFLAGS_SPU_DISTRIBUTION_FILE_CommandBufferExecute=$(MAKE_ROOT)/Tools/CommandBufferExecute_FunctionDist.cfg

PROJECT_XFLAGS_SPUJOB_UpdateParticles = -Os -ffast-math -fomit-frame-pointer

# List of interface header files.  The make system expects the following
# vairables:
#
# UNIQUE_IFACE_LIST
#	List of unique interface header files.
# UNIQUE_IFACE_DIR
#	The directory containing the unique interface files.  This directory
#	is interpreted relative to $(CODE_ROOT) for locating the input header
#	files and $(BUILD_ROOT) for creating the patched header files.
# UNIQUE_IMPL_LIST
#	List of header file defining the implementation classes for the unique
#	interface header files.  These are interpreted relative to
#	$(CODE_ROOT).

UNIQUE_IFACE_DIR := CryEngine/CryCommon \
					CryEngine/CryAISystem/PerceptionHandler \
					CryEngine/Cry3DEngine \
					CryEngine/CryAnimation \
					CryEngine/CryMovie \
					CryEngine/CryNetwork \
					CryEngine/CryPhysics \
					CryEngine/CrySystem \
					CryEngine/CryEntitySystem \
					CryEngine/Cry3DEngine/MeshCompiler \
					CryEngine/CrySoundSystem \
					CryEngine/RenderDll/Common \
					CryEngine/CryNetwork/VOIP \
					CryEngine/RenderDll/Common/Shaders \
					CryEngine/CryNetwork/Streams \
					CryEngine/CryNetwork/Protocol \
					CryEngine/CryScriptSystem \
					CryEngine/CryNetwork/Socket \
					CryEngine/CrySystem/Scaleform \
					CryEngine/CryAISystem \
					CryEngine/CryFont \
					\
					GameSkeleton/GameDll/GameCore \
					GameSkeleton/GameDll/GameFramework \
\
					CryEngine/CryAction \
					CryEngine/CryAction/DebrisMgr \
					CryEngine/CryAction/Network \
					CryEngine/CryAction/DialogSystem \
					CryEngine/CryAction/TestSystem \
					
					
UNIQUE_IFACE_BASE_DIR := CryEngine/

UNIQUE_IFACE_CODE_ROOT := $(CODE_ROOT)
					
UNIQUE_IFACE_LIST := \
	CryCommon/IGame.h \
	CryCommon/IEditorGame.h \
	CryCommon/IGameStartup.h \
	CryCommon/ILog.h \
	CryCommon/ICryAnimation2.h \
	CryCommon/I3DSampler.h \
	CryCommon/ILMSerializationManager.h \
	CryCommon/IFacialAnimation.h \
	CryCommon/I3DEngine.h \
	CryCommon/IAIGroup.h \
	CryCommon/IScriptSystem.h \
	CryCommon/IShader.h \
	CryCommon/IVideoPlayer.h \
	CryCommon/ISystem.h \
	CryCommon/IFlowSystem.h \
	CryCommon/IIndexedMesh.h \
	CryCommon/IBlackBoard.h \
	CryCommon/IBSSProfileManager.h \
	CryCommon/IAgent.h	\
	CryCommon/IAIRecorder.h \
	CryCommon/IAISystem.h \
	CryCommon/IGoalPipe.h \
	CryCommon/IAnimationGraphSystem.h \
	CryCommon/IAVI_Reader.h \
	CryCommon/IBudgetingSystem.h \
	CryCommon/ICmdLine.h \
	CryCommon/ICombatLog.h \
	CryCommon/IConsole.h \
	CryCommon/ICryPak.h \
	CryCommon/IDataProbe.h \
	CryCommon/IDebugHistory.h \
	CryCommon/IDialogSystem.h \
	CryCommon/IDiskProfiler.h \
	CryCommon/IEntityClass.h \
	CryCommon/IEntity.h \
	CryCommon/IEntityProxy.h \
	CryCommon/IEntitySystem.h \
	CryCommon/IGameFramework.h \
	CryCommon/IGameTokens.h \
	CryCommon/IInterestSystem.h \
	CryCommon/IJoystick.h \
	CryCommon/IMaterialEffects.h \
	CryCommon/IMaterial.h \
	CryCommon/IMemory.h \
	CryCommon/IMovieSystem.h \
	CryCommon/IMusicSystem.h \
	CryCommon/INetwork.h \
	CryCommon/INetworkService.h \
	CryCommon/IPersonalBehaviorTree.h \
	CryCommon/IPlatformOS.h \
	CryCommon/IReadWriteXMLSink.h \
	CryCommon/IRenderer.h \
	CryCommon/IRenderMesh.h \
	CryCommon/IParticles.h \
	CryCommon/ISimpleHttpServer.h \
	CryCommon/ISound.h \
	CryCommon/ISoundMoodManager.h \
	CryCommon/ISurfaceType.h \
	CryCommon/ITacticalPointSystem.h \
	CryCommon/ITexture.h \
	CryCommon/IThreadTask.h \
	CryCommon/IValidator.h \
	CryCommon/IVisualLog.h \
	CryCommon/IXml.h \
	CryCommon/IEntityRenderState.h \
	CryCommon/IRemoteControl.h \
	CryCommon/ILocalizationManager.h \
	CryCommon/CryName.h \
	CryCommon/FrameProfiler.h \
	CryCommon/physinterface.h \
	CryCommon/IStreamEngine.h \
	CryCommon/IEmotionalSystem.h \
	CryCommon/ICryAnimation.h \
	CryCommon/ICharacterPartsManager.h \
	CryCommon/IStatObj.h \
	CryCommon/ITestSystem.h \
	CryCommon/ICompoundCharacter.h \
	CryCommon/IEnginePropertyBlending.h \
	CryCommon/CREBaseCloud.h \
	CryCommon/IHardwareMouse.h \
	CryCommon/ITextModeConsole.h \
	CryCommon/IFlashPlayer.h \
	CryCommon/IGameStatistics.h \
	CrySystem/Scaleform/GRendererXRender.h \
	CrySystem/Scaleform/SharedResources.h \
	\
	RenderDll/Common/RenderAuxGeom.h \
	RenderDll/Common/IColorGradingControllerInt.h \
	RenderDll/Common/Shaders/Shader.h \
	\
	Cry3DEngine/MeshCompiler/TangentSpaceCalculation.h \
	\
	CrySoundSystem/ISoundBuffer.h \
	CrySoundSystem/ISoundAssetManager.h \
	\
	CryNetwork/VOIP/IVoiceEncoder.h \
	CryNetwork/Streams/SimpleInputStream.h \
	CryNetwork/Protocol/INubMember.h \
	CryNetwork/VOIP/IVoicePacketListener.h \
	\
	CryScriptSystem/ScriptSystem.cpp \
	\
	CryFont/XmlStream.h \
	\
	CryAction/ILevelSystem.h \
	CryAction/IGameObjectSystem.h \
	CryAction/IActionMapManager.h \
	CryAction/IDeferredRaycastManager.h \
	CryAction/IVehicleSystem.h \
	CryAction/ICooperativeAnimationManager.h \
	CryAction/IEffectSystem.h \
	CryAction/IViewSystem.h \
	CryAction/IAnimationGraph.h \
	CryAction/DebrisMgr/IDebrisMgr.h \
	CryAction/IMetadataRecorder.h \
	CryAction/IPlayerProfiles.h \
	CryAction/IItemSystem.h \
	CryAction/IGameRulesSystem.h \
	CryAction/IForceFeedbackSystem.h \
	CryAction/IActorSystem.h \
	CryAction/IGameObject.h \
	CryAction/ISubtitleManager.h \
	CryAction/Network/CVarListProcessor.h \
	CryAction/DialogSystem/DialogSession.h \
	CryAction/ICachedAIValues.h \
	CryAction/IUIDraw.h \
	CryAction/IGameplayRecorder.h \
	CryAction/IRangeSignaling.h \
	CryAction/TestSystem/IGameStateRecorder.h \
	
	
UNUSED_UNIQUE_IFACE_LIST := \
	CryAction/AIProxy.h \
	

UNIQUE_IMPL_LIST := \
	CryCommon/CGFContent.h \
	\
	CryFont/FFontXML.cpp \
	\
	Cry3DEngine/VoxMan.h \
	Cry3DEngine/3DSamplerOctree.h \
	Cry3DEngine/3dEngine.h \
	Cry3DEngine/3dEngineMerge.cpp \
	Cry3DEngine/AutoCubeMapRenderNode.h \
	Cry3DEngine/CloudRenderNode.h \
	Cry3DEngine/DecalRenderNode.h \
	Cry3DEngine/DistanceCloudRenderNode.h \
	Cry3DEngine/FogVolumeRenderNode.h \
	Cry3DEngine/IndexedMesh.h \
	Cry3DEngine/IrradianceVolumeRenderNode.h \
	Cry3DEngine/LightEntity.h \
	Cry3DEngine/MatMan.h \
	Cry3DEngine/Material.h \
	Cry3DEngine/ObjMan.h \
	Cry3DEngine/ParticleEffect.h \
	Cry3DEngine/ParticleEmitter.h \
	Cry3DEngine/PhysCallbacks.h \
	Cry3DEngine/PrismRenderNode.h \
	Cry3DEngine/RoadRenderNode.h \
	Cry3DEngine/RopeRenderNode.h \
	Cry3DEngine/StatObj.h \
	Cry3DEngine/SurfaceTypeManager.h \
	Cry3DEngine/TimeOfDay.h \
	Cry3DEngine/VisAreas.h \
	Cry3DEngine/VolumeObjectRenderNode.h \
	Cry3DEngine/VoxTerrain.h \
	Cry3DEngine/WaterVolumeRenderNode.h \
	Cry3DEngine/WaterWaveRenderNode.h \
	Cry3DEngine/partman.h \
	Cry3DEngine/terrain.h \
	Cry3DEngine/MeshCompiler/MeshCompiler.cpp \
	\
	CryAISystem/AIDbgRecorder.h \
	CryAISystem/AIGroup.h \
	CryAISystem/AISignal.h \
	CryAISystem/BehaviorTree/PersonalBehaviorTree.h \
	CryAISystem/BehaviorTree/ProfileDictionary.h \
	CryAISystem/BlackBoard.h \
	CryAISystem/CAISystem.h \
	CryAISystem/AIActions.h \
	CryAISystem/CentralInterestManager.h \
	CryAISystem/EmotionalSystem/EmotionalSystem.h \
	CryAISystem/GoalPipe.h \
	CryAISystem/Graph.h \
	CryAISystem/PersonalInterestManager.h \
	CryAISystem/TacticalPointSystem/TacticalPointSystem.h \
	CryAISystem/AIGroupTactic.h \
	\
	CryAnimation/AnimationManager.h \
	CryAnimation/AttachmentManager.h \
	CryAnimation/CharacterManager.h \
	CryAnimation/FacialAnimation/FaceAnimSequence.h \
	CryAnimation/FacialAnimation/FaceEffector.h \
	CryAnimation/FacialAnimation/FaceEffectorLibrary.h \
	CryAnimation/FacialAnimation/FaceJoystick.h \
	CryAnimation/FacialAnimation/FaceState.h \
	CryAnimation/FacialAnimation/FacialInstance.h \
	CryAnimation/FacialAnimation/FacialModel.h \
	CryAnimation/FacialAnimation/LipSync.h \
	CryAnimation/Model.h \
	CryAnimation/ModelAnimationSet.h \
	CryAnimation/Morphing.h \
	CryAnimation/SkeletonAnim.h \
	CryAnimation/SkeletonPose.h \
	CryAnimation/FacialAnimation/FaceAnimation.h \
	CryAnimation/PoseModifier/PoseBlenderAim.h \
	CryAnimation/ModelSkeleton.h \
	\
	CryEntitySystem/Area.h \
	CryEntitySystem/AreaManager.h \
	CryEntitySystem/AreaProxy.h \
	CryEntitySystem/BreakableManager.h \
	CryEntitySystem/CameraProxy.h \
	CryEntitySystem/Entity.h \
	CryEntitySystem/EntityArchetype.h \
	CryEntitySystem/EntityClass.h \
	CryEntitySystem/EntityClassRegistry.h \
	CryEntitySystem/EntityIt.h \
	CryEntitySystem/EntitySystem.h \
	CryEntitySystem/FlowGraphProxy.h \
	CryEntitySystem/PhysicsProxy.h \
	CryEntitySystem/RenderProxy.h \
	CryEntitySystem/RopeProxy.h \
	CryEntitySystem/ScriptProxy.h \
	CryEntitySystem/SoundProxy.h \
	CryEntitySystem/SubstitutionProxy.h \
	CryEntitySystem/TriggerProxy.h \
	\
	CryInput/BaseInput.h \
	CryInput/InputDevice.h \
	\
	CryMovie/AnimNode.h \
	CryMovie/AnimSequence.h \
	CryMovie/Movie.h \
	CryMovie/SequenceIt.h \
	\
	CryNetwork/Context/BreakagePlayback.h \
	CryNetwork/Context/ContextEstablisher.h \
	CryNetwork/Context/ContextView.h \
	CryNetwork/Context/NetContext.h \
	CryNetwork/Context/ServerContextView.cpp \
	CryNetwork/Context/VoiceContext.h \
	CryNetwork/Http/AutoConfigDownloader.h \
	CryNetwork/Http/SimpleHttpServer.h \
	CryNetwork/Network.h \
	CryNetwork/Protocol/CTPEndpoint.cpp \
	CryNetwork/Protocol/NetNub.cpp \
	CryNetwork/Protocol/NetNub.h \
	CryNetwork/RemoteControl/RemoteControl.h \
	CryNetwork/Services/CryLAN/LanQueryListener.h \
	CryNetwork/VOIP/SpeexCodec.cpp \
	CryNetwork/Streams/CompressingStream.h \
	CryNetwork/Protocol/NetChannel.h \
	CryNetwork/DistributedLogger.h \
	CryNetwork/Socket/TCPStreamSocket.h \
	CryNetwork/Socket/UDPDatagramSocket.h \
	\
	CryPhysics/geometry.h \
	CryPhysics/tetrlattice.h \
	CryPhysics/geoman.h \
	\
	CryScriptSystem/FunctionHandler.h \
	CryScriptSystem/ScriptSystem.h \
	CryScriptSystem/ScriptTable.h \
	\
	CrySoundSystem/Sound.h \
	CrySoundSystem/Microphone.h \
	CrySoundSystem/SoundAssetManager.h \
	CrySoundSystem/AudioDeviceFmodEx400.h \
	CrySoundSystem/MusicSystem/MusicSystem.h \
	\
	CrySystem/Log.h \
	CrySystem/AVI_Reader.h \
	CrySystem/BudgetingSystem.h \
	CrySystem/CmdLine.h \
	CrySystem/CmdLineArg.h \
	CrySystem/CryPak.h \
	CrySystem/DataProbe.h \
	CrySystem/DiskProfiler.h \
	CrySystem/FrameProfileSystem.h \
	CrySystem/HardwareMouse.h \
	CrySystem/LocalizedStringManager.h \
	CrySystem/PhysRenderer.h \
	CrySystem/PlatformOS/PlatformOS.h \
	CrySystem/RefReadStream.h \
	CrySystem/RefStreamEngine.h \
	CrySystem/Scaleform/FlashPlayerInstance.h \
	CrySystem/Statistics.cpp \
	CrySystem/System.h \
	CrySystem/ThreadTask.h \
	CrySystem/Validator.h \
	CrySystem/XConsole.h \
	CrySystem/XML/ReadWriteXMLSink.h \
	CrySystem/XML/XmlUtils.h \
	CrySystem/TestSystemLegacy.h \
	CrySystem/XML/xml.h \
	CrySystem/MemoryManager.h \
	CrySystem/EnginePropertyBlending.h \
	CrySystem/XML/XmlUtils.cpp \
	CrySystem/RefReadStreamProxy.h \
	CrySystem/SystemEventDispatcher.h \
	CrySystem/XML/xml.cpp \
	\
	RenderDll/Common/PostProcess/PostEffects.h \
	RenderDll/Common/RenderMesh2.h \
	RenderDll/Common/Renderer.cpp \
	RenderDll/Common/Textures/Texture.h \
	RenderDll/Common/VideoPlayerInstance.h \
	RenderDll/XRenderD3D9/D3DColorGradingController.h \
	RenderDll/XRenderD3D9/D3DHWShader.h \
	RenderDll/Common/RendElements/CRECloud.h \
	RenderDll/XRenderD3D9/D3DRenderAuxGeom.h \
	

UNUSED_UNIQUE_IMPL_LIST :=	\
	CryAction/DeferredRaycastWrapper.h \
	CryAction/VehicleSystem/VehicleAnimation.h \
	CryAction/GameObjects/GameObject.h \
	CryAction/ViewSystem/View.h \
	CryAction/AnimationGraph/AnimationGraph.h \
	CryAction/ActionMapManager.h \
	CryAction/EffectSystem/Effect.h \
	CryAction/GameObjects/GameObjectSystem.h \
	CryAction/DebrisMgr/DebrisMgr.h \
	CryAction/MetadataRecorder/MetadataRecorder.cpp \
	CryAction/ActionFilter.h \
	CryAction/PlayerProfiles/PlayerProfile.h \
	CryAction/EquipmentManager.h \
	CryAction/ItemSystem.h \
	CryAction/PlayerProfiles/PlayerProfileManager.h \
	CryAction/GameRulesSystem.h \
	CryAction/ActorSystem.h \
	CryAction/AIHandler.h \
	CryAction/SubtitleManager.h \
	CryAction/VehicleSystem/VehicleSeat.h \
	CryAction/PlayerProfiles/PlayerProfileManager.cpp \
	CryAction/VehicleSystem/VehicleDamagesTemplateRegistry.h \
	CryAction/Network/GameContext.cpp \
	CryAction/DialogSystem/FlowDialogNode.cpp \
	CryAction/UIDraw/UIDraw.h \
	CryAction/FlowSystem/Nodes/Vehicle/FlowVehicleMoveActionMult.h \
	CryAction/Network/GameChannel.h \
	CryAction/EffectSystem/GroundEffect.h \
	CryAction/GameplayRecorder/GameplayRecorder.h \
	CryAction/VehicleSystem/VehicleDamagesGroup.h \
	CryAction/FlowSystem/FlowGraph.h \
	CryAction/PlayerProfiles/PlayerProfileImplFS.cpp \
	CrySystem/UnixConsole.h \
	CryAction/ActionMap.h \
	CryAction/VehicleSystem/VehicleHelper.h \
	CryAction/Statistics/GameStatistics.h \
	CryAction/ItemParams.h \
	CryAction/AnimationGraph/AnimationGraphState.cpp \
	CryAction/RangeSignalingSystem/RangeSignaling.h \
	CryAction/ForceFeedbackSystem/ForceFeedbackSystem.h \
	CryAction/AnimationGraph/AnimationGraphManager.cpp \
	CryAction/AnimationGraph/AnimationGraphManager.h \
	CryAction/AnimationGraph/DebugHistory.h \
	CryAction/CharacterPartsManager.h \
	CryAction/CombatLog/CombatLog.h \
	CryAction/CryAction.h \
	CryAction/DialogSystem/DialogSystem.cpp \
	CryAction/DialogSystem/DialogSystem.h \
	CryAction/FlowSystem/FlowData.h \
	CryAction/FlowSystem/FlowGraph.cpp \
	CryAction/FlowSystem/FlowSystem.h \
	CryAction/FlowSystem/Inspectors/FlowInspectorDefault.h \
	CryAction/FlowSystem/Nodes/FlowCompositeNode.h \
	CryAction/FlowSystem/Nodes/FlowTrackEventNode.h \
	CryAction/FlowSystem/Nodes/PlaySequenceNode.cpp \
	CryAction/GameTokens/GameToken.h \
	CryAction/GameTokens/GameTokenSystem.h \
	CryAction/LevelSystem.cpp \
	CryAction/MaterialEffects/MaterialEffects.h \
	CryAction/MusicLogic/MusicLogic.h \
	CryAction/Network/GameContext.h \
	CryAction/Network/GameQueryListener.h \
	CryAction/Network/GameStatsConfig.h \
	CryAction/Network/VoiceController.h \
	CryAction/Network/VoiceListener.h \
	CryAction/PersistantDebug.h \
	CryAction/RemoteControl/RConClientListener.h \
	CryAction/RemoteControl/RConServerListener.h \
	CryAction/Serialization/XMLScriptLoader.cpp \
	CryAction/SimpleHttpServer/SimpleHttpServerListener.h \
	CryAction/ViewSystem/ViewSystem.h \
	CryAction/VisualLog/VisualLog.h \
	CryAction/TestSystem/TestProfiler.h \
	CryAction/VehicleSystem/VehiclePartSubPartWheel.h \
	CryAction/CooperativeAnimationManager\CooperativeAnimationManager.h \
	CryAction/Level.h \
	CryAction/VehicleSystem.h \
	CryAction/LevelSystem.h \
	CryAction/VehicleSystem/VehicleComponent.h \
	CryAction/EffectSystem/EffectSystem.h \
	
# Add Interfaces of GameCode

# Game Stuff	
ifeq ($(GameVersion), Game)
	UNIQUE_GAME_IFACE_LIST := 
	 
	UNIQUE_GAME_IMPL_LIST := \
		GameSkeleton/GameDll/GameCore/Game.h \
		GameSkeleton/GameDll/GameCoreEditorGame.h \		
		GameSkeleton/GameDll/GameCore/GameStartup.h \
		GameSkeleton/GameDll/GameFramework/MiniGameFramework.h \
		GameSkeleton/GameDll/GameFramework/MiniGameContext.h \
		GameSkeleton/GameDll/GameFramework/Level/MiniLevel.h \
		GameSkeleton/GameDll/GameFramework/Level/MiniLevelRotation.h \
		GameSkeleton/GameDll/GameFramework/Level/MiniLevelSystem.h \
		GameSkeleton/GameDll/GameFramework/Level/MiniLevelInfo.h \
		
	UNIQUE_IFACE_DIR := $(UNIQUE_IFACE_DIR) 
endif
		
# CryEngine.mk
# vim:ts=8:sw=8

