#ifndef __RTP_Simple_Server__h__
#define __RTP_Simple_Server__h__

#include "RTPHeader.h"

typedef UINT_PTR SOCKET;


struct IRTPPacketListener
{
	virtual void OnRTPPacket( SFixedRTPHeader* pRtpHeader, byte* pRtpPayload, int payloadBytes ) = 0;
};



class CRTPSimpleServer
	: public IRTPPacketListener
{
public:
	CRTPSimpleServer( int port );
	virtual ~CRTPSimpleServer();

	void SetPacketListener( IRTPPacketListener* pRtpPacketListener );

	void Update();

	int64 GetWallclockTimestamp() const;
	int64 ConvertToWallclockTimestamp( SFixedRTPHeader* pRtpHeader, int64 samplingFrequency ) const;

	void ClearSynchronisationEntries();

private:
	virtual void OnRTPPacket( SFixedRTPHeader* pRtpHeader, byte* pRtpPayload, int payloadBytes ) {}

	bool ReadData();
	
	void CreateSynchronisationEntry( SFixedRTPHeader* pRtpHeader );
	int64 GetAsynchTimestamp() const;

private:
	SOCKET m_socket;

	IRTPPacketListener* m_pRtpPacketListener;

	struct SSynchronisationInfo
	{
		int64 wallclockStartTimestamp;

		SSynchronisationInfo( int64 wallclockStartTimestamp_ = 0 )
			: wallclockStartTimestamp( wallclockStartTimestamp_ )
		{
		}
	};

	int64 m_wallclockTimestamp;

	typedef std::map< uint32, SSynchronisationInfo > SynchronisationSources;
	SynchronisationSources m_synchronisationSources;

	SSynchronisationInfo m_dummySynchronisationInfo;

	static int rtp_server_debug;
};

#endif