#include "StdAfx.h"
#include "TGalleryConfiguration.h"

const char* CTGalleryConfiguration::DEFAULT_CONFIG_FILENAME( "tgallery.xml" );

void MapNodeContent( XmlNodeRef node, const char* name, string& out )
{
	if ( ! node )
	{
		return;
	}

	if ( strcmpi( node->getTag(), name ) == 0 )
	{
		out = node->getContent();
	}
}

void MapNodeContent( XmlNodeRef node, const char* name, int& out )
{
	if ( ! node )
	{
		return;
	}

	if ( strcmpi( node->getTag(), name ) == 0 )
	{
		out = atoi( node->getContent() );
	}
}

CTGalleryConfiguration::CTGalleryConfiguration( const char* filename )
: m_port( 33428 )
, m_mapName( "Talkie" )
, m_characterName( "Hawker" )
, m_initialAnimationName( "relaxed_idleListening_01" )
, m_visimExpirationMilliseconds( 200 )
, m_bufferMilliseconds( 100 )
, m_networkBufferMilliseconds( 5 )
, m_audioBufferBytes( 51200 )
{
	XmlNodeRef root = GetISystem()->GetXmlUtils()->LoadXmlFile( filename );
	if ( ! root ) 
	{
		return;
	}

	for ( int i = 0; i < root->getChildCount(); i++ )
	{
		XmlNodeRef childNode = root->getChild( i );
		MapNodeContent( childNode, "map_name", m_mapName );
		MapNodeContent( childNode, "character_name", m_characterName );
		MapNodeContent( childNode, "initial_animation_name", m_initialAnimationName );
		MapNodeContent( childNode, "rtp_port", m_port );
		MapNodeContent( childNode, "visim_expiration_milliseconds", m_visimExpirationMilliseconds );
		MapNodeContent( childNode, "buffer_milliseconds", m_bufferMilliseconds );
		MapNodeContent( childNode, "network_buffer_milliseconds", m_networkBufferMilliseconds );
		MapNodeContent( childNode, "audio_buffer_bytes", m_audioBufferBytes );
		if ( strcmpi( childNode->getTag(), "visims" ) == 0 )
		{
			for ( int j = 0; j < childNode->getChildCount(); j++ )
			{
				XmlNodeRef visimNode = childNode->getChild( j );
				
				int visimId = 0;
				visimNode->getAttr( "id", visimId );
				
				string effectorName = visimNode->getAttr( "effector_name" );
				
				m_visimeIdToEffectorName[ visimId ] = effectorName;
			}
		}
	}
}

CTGalleryConfiguration::~CTGalleryConfiguration()
{

}

int CTGalleryConfiguration::GetRTPPort() const
{
	return m_port;
}

const char* CTGalleryConfiguration::GetMapName() const
{
	return m_mapName;
}

const char* CTGalleryConfiguration::GetCharacterName() const
{
	return m_characterName;
}

const char* CTGalleryConfiguration::GetInitialAnimationName() const
{
	return m_initialAnimationName;
}

int CTGalleryConfiguration::GetNumVisims() const
{
	return m_visimeIdToEffectorName.size();
}

const char* CTGalleryConfiguration::GetVisimEffectorName( int visimId ) const
{
	std::map< int, string >::const_iterator cit = m_visimeIdToEffectorName.find( visimId );

	bool effectorNameFound = ( cit != m_visimeIdToEffectorName.end() );
	if ( ! effectorNameFound )
	{
		return NULL;
	}

	return cit->second;
}

int CTGalleryConfiguration::GetVisimExpirationMilliseconds() const
{
	return m_visimExpirationMilliseconds;
}

int CTGalleryConfiguration::GetBufferMilliseconds() const
{
	return m_bufferMilliseconds;
}

int CTGalleryConfiguration::GetNetworkBufferMilliseconds() const
{
	return m_networkBufferMilliseconds;
}

int CTGalleryConfiguration::GetAudioBufferBytes() const
{
	return m_audioBufferBytes;
}