#ifndef __T_GALLERY_CONFIGURATION__H__
#define __T_GALLERY_CONFIGURATION__H__



class CTGalleryConfiguration
{
public:
	static const char* DEFAULT_CONFIG_FILENAME;

	CTGalleryConfiguration( const char* filename = DEFAULT_CONFIG_FILENAME );
	virtual ~CTGalleryConfiguration();

	int GetRTPPort() const;
	const char* GetMapName() const;
	const char* GetCharacterName() const;
	const char* GetInitialAnimationName() const;
	
	int GetNumVisims() const;
	const char* GetVisimEffectorName( int visimId ) const;

	int GetVisimExpirationMilliseconds() const;
	int GetBufferMilliseconds() const;
	int GetNetworkBufferMilliseconds() const;

	int GetAudioBufferBytes() const;
	
private:
	int m_port;
	string m_mapName;
	string m_characterName;
	string m_initialAnimationName;
	std::map< int, string > m_visimeIdToEffectorName;

	int m_visimExpirationMilliseconds;
	int m_bufferMilliseconds;
	int m_networkBufferMilliseconds;

	int m_audioBufferBytes;
};

#endif