#pragma once
#ifndef TALKIEACTOR_H
#define TALKIEACTOR_H

//#include <ILevelSystem.h>
//#include <IGameFramework.h>
//#include <IEntitySystem.h>
//#include <ISound.h>

#include <Talkie/RTPSimpleServer.h>
#include <Talkie/TGalleryConfiguration.h>
#include <Talkie/TalkieAudioBuffer.h>

#include "Actor.h"

#define AUDIO_PACKET_SIZE 480

namespace Talkie
{
  //////////////////////////////////////////////////////////////////////////
  struct SAudioPayload
  {
    // TODO: this is misleading, as it's not really safe to
    //       use the data when another packet is received.
    byte data[ AUDIO_PACKET_SIZE ];
  };

  //////////////////////////////////////////////////////////////////////////
  struct VisimInfo
  {
    int64 wallclockTimestamp;
    int visimId;

    bool operator < ( const VisimInfo& vi ) const
    {
      bool isLowerPriority = ( vi.wallclockTimestamp < wallclockTimestamp );
      return isLowerPriority;
    }
  };

  //////////////////////////////////////////////////////////////////////////
  struct EmotionInfo
  {
    int64 wallclockTimestamp;
    IFacialEffector* emotionEffector;
    float emotionIntensity;

    bool operator < ( const EmotionInfo& ei ) const
    {
      bool isLowerPriority = ( ei.wallclockTimestamp < wallclockTimestamp );
      return isLowerPriority;
    }
  };

  //////////////////////////////////////////////////////////////////////////
  struct AnimationInfo
  {
    int64 wallclockTimestamp;
    char animationName[ 64 ];
    float animationIntensity;

    bool operator < ( const AnimationInfo& ai ) const
    {
      bool isLowerPriority = ( ai.wallclockTimestamp < wallclockTimestamp );
      return isLowerPriority;
    }
  };
}

//////////////////////////////////////////////////////////////////////////
class CTalkieActor : public CActor
  , public ILevelSystemListener
  , public IGameFrameworkListener
  , public IRTPPacketListener
  , public INetworkSoundListener
  , public IEntityEventListener

/*
class CActor :
  public CGameObjectExtensionHelper<CActor, IActor>,
  public IGameObjectView,
  public IGameObjectProfileManager,
  public ISoundEventListener

class CTalkie
*/
{
public:
  CTalkieActor();
  virtual ~CTalkieActor();

  // ILevelSystemListener
  virtual void OnLevelNotFound( const char* levelName ) {}
  virtual void OnLoadingStart( ILevelInfo* pLevel ) {}
  virtual void OnLoadingComplete( ILevel* pLevel );
  virtual void OnLoadingError( ILevelInfo* pLevel, const char* error ) {}
  virtual void OnLoadingProgress( ILevelInfo* pLevel, int progressAmount ) {}
  // ~ILevelSystemListener

  // IGameFrameworkListener
  virtual void OnPostUpdate( float deltaTime );
  virtual void OnSaveGame( ISaveGame* pSaveGame ) {}
  virtual void OnLoadGame( ILoadGame* pLoadGame ) {}
  virtual void OnLevelEnd( const char* nextLevel ) {}
  virtual void OnActionEvent( const SActionEvent& event ) {}
  // ~IGameFrameworkListener

  // IRTPPacketListener
  virtual void OnRTPPacket( SFixedRTPHeader* pRtpHeader, byte* pRtpPayload, int payloadBytes );
  // ~IRTPPacketListener

  // INetworkSoundListener
  virtual bool FillDataBuffer( unsigned int bitsPerSample, unsigned int samplesPerSecond, unsigned int numSamples, void* pData );
  virtual void OnActivate( bool active ) {}
  virtual void SetSoundPlaybackDistances( float max3dDistance, float min2dDistance ) {}
  virtual void UpdateSound3dPan() {}
  // ~INetworkSoundListener

  // IEntityEventListener
  virtual void OnEntityEvent( IEntity* pEntity, SEntityEvent& event );
  // ~IEntityEventListener


  // VisimeController
  void ClearVisimQueue();
  void QueueVisim( int64 wallclockTimestamp, int64 visimWallclockTimestamp, int visimId );
  void UpdateVisims( int64 wallclockTimestamp );
  void RemoveVisimEffectors();
  // ~VisimeController

  // EmotionController
  void ClearEmotionQueue();
  void QueueEmotion( int64 wallclockTimestamp, int64 emotionWallclockTimestamp, IFacialEffector* emotionEffector, float intensity );
  void UpdateEmotions( int64 wallclockTimestamp );
  void RemoveEmotionEffectors();
  // ~EmotionController

  // AnimationController
  void ClearAnimationQueue();
  void QueueAnimation( int64 wallclockTimestamp, int64 animationWallclockTimestamp, const char* animationName );
  void UpdateAnimations( int64 wallclockTimestamp );
  void SetDefaultAnimation();
  void SetAnimation( const char* animationName );
  // ~AnimationController

  // LookAtController
  void SetLookAtParameters( bool faceDetected, float screenX, float screenY );
  void UpdateLookAt();
  // ~LookAtController

  // IGameObjectExtension
  virtual void GetMemoryStatistics(ICrySizer * s) {};
  virtual void SetAuthority(bool auth) {};
  virtual void SerializeXML( XmlNodeRef& node, bool bLoading ) {};
  // ~IGameObjectExtension

protected:
  // CActor
  virtual IActorMovementController * CreateMovementController() {return NULL;};
  // ~CActor

private:
  void OnRTPVisim( SFixedRTPHeader* pHeader, byte* pData, int payloadBytes );
  void OnRTPAudio( SFixedRTPHeader* pHeader, Talkie::SAudioPayload* pPayload, int payloadBytes );
  void OnRTPEmotion( SFixedRTPHeader* pHeader, byte* pData, int payloadBytes );
  void OnRTPAnimation( SFixedRTPHeader* pHeader, byte* pData, int payloadBytes );
  void OnRTPLookAt( SFixedRTPHeader* pHeader, byte* pData, int payloadBytes );

  int64 ConvertToWallclockTimestamp(SFixedRTPHeader* pHeader, int64 frequency);

  void ProcessLookAtWithOutFace();
  void ProcessLookAtWithFace();
  bool IsAbleToProcessLookAt();
  bool SetLocalSound();
  bool SetupLocalInstances();
  void TryPlaySound();
  void FillListOfEffectors();

private:
  float m_lookAtScreenX;
  float m_lookAtScreenY;

  int64 m_wallclockOfAudioStart;

  int32 m_emotionEffectorChannel;
  uint32 m_audioPacketSSRC;

  int m_audioBytesRead;

  bool m_faceDetected;

  CAudioBuffer* m_pAudioBuffer;

  IEntity* m_pTalkieEntity;
  ICharacterInstance* m_pCharacterInstance;
  IAnimationSet* m_pAnimationSet;
  ISkeletonAnim* m_pSkeletonAnim;
  ISkeletonPose* m_pSkeletonPose;
  IFacialEffectorsLibrary* m_pFacialEffectorsLibrary;
  IFacialInstance* m_pFacialInstance;
  ISound* m_sound;

  CTGalleryConfiguration m_config;
  CRTPSimpleServer m_rtpServer;
  CryCriticalSection m_audioLock;

  std::vector< IFacialEffector* > m_effectors;
  std::priority_queue< Talkie::VisimInfo, std::vector< Talkie::VisimInfo > > m_visimPlayQueue;
  std::priority_queue< Talkie::EmotionInfo, std::vector< Talkie::EmotionInfo > > m_emotionPlayQueue;
  std::priority_queue< Talkie::AnimationInfo, std::vector< Talkie::AnimationInfo > > m_animationPlayQueue;
  
};

#endif
