#include "StdAfx.h"

#include "Game.h"
#include "GameCVars.h"

#include "Talkie/TalkieAudioBuffer.h"

//////////////////////////////////////////////////////////////////////////
void CAudioBuffer::WriteData( const byte* pDataIn, int dataBytes, int offsetBytes )
{
	if ( GetBufferBytes() < dataBytes )
	{
		if ( g_pGame->GetCVars()->tgallery_debugAudioPackets == 1 )
		{
			CryLog( "audio couldn't be written to buffer: Buffer full." );
		}
		return;
	}

	if ( dataBytes == 0 )
	{
		if ( g_pGame->GetCVars()->tgallery_debugAudioPackets == 1 )
		{
			CryLog( "audio couldn't be written to buffer: No Data." );
		}
		return;
	}

	int writeStart = ( ( m_dataStart + offsetBytes ) + GetBufferBytes() ) % GetBufferBytes();
	bool wrapAroundWrite = ( GetBufferBytes() < writeStart + dataBytes );
	if ( wrapAroundWrite )
	{
		int bytesBeforeWrapAround = GetBufferBytes() - writeStart;
		memcpy( m_buffer + writeStart, pDataIn, bytesBeforeWrapAround );
		memcpy( m_buffer, pDataIn + bytesBeforeWrapAround, dataBytes - bytesBeforeWrapAround );
	}
	else
	{
		memcpy( m_buffer + writeStart, pDataIn, dataBytes );
	}

	m_dataBytes = std::min( std::max( m_dataBytes, offsetBytes + dataBytes ), GetBufferBytes() );
}

//////////////////////////////////////////////////////////////////////////
void CAudioBuffer::ReadData( byte* pDataOut, int dataBytes, int offsetBytes )
{
	if ( GetBufferBytes() < dataBytes )
	{
		if ( g_pGame->GetCVars()->tgallery_debugAudioPackets == 1 )
		{
			CryLog( "audio couldn't be read from buffer." );
		}
		return;
	}

	if ( dataBytes == 0 )
	{
		return;
	}

	int readStart = ( ( m_dataStart + offsetBytes ) + GetBufferBytes() ) % GetBufferBytes();

  bool wrapAroundRead = ( GetBufferBytes() < readStart + dataBytes );
	if ( wrapAroundRead )
	{
		int bytesBeforeWrapAround = GetBufferBytes() - readStart;
		memcpy( pDataOut, m_buffer + readStart, bytesBeforeWrapAround );
		memcpy( pDataOut + bytesBeforeWrapAround, m_buffer, dataBytes - bytesBeforeWrapAround );
	}
	else
	{
		memcpy( pDataOut, m_buffer + readStart, dataBytes );
	}
}
