#ifndef __TALKIE_AUDIO_BUFFER_H__
#define __TALKIE_AUDIO_BUFFER_H__

//////////////////////////////////////////////////////////////////////////
class CAudioBuffer
{
public:
  CAudioBuffer( int bufferBytes )
    : m_bufferBytes( bufferBytes )
    , m_dataStart( 0 )
    , m_dataBytes( 0 )
  {
    assert( 0 < GetBufferBytes() );

    m_buffer = new byte[ GetBufferBytes() ];
    memset( m_buffer, 0, GetBufferBytes() );
  }

  ~CAudioBuffer()
  {
    delete[] m_buffer;
  }

  void WriteData( const byte* pDataIn, int dataBytes, int offsetBytes = 0 );
  void ReadData( byte* pDataOut, int dataBytes, int offsetBytes = 0 );

  void Advance( int dataBytes )
  {
    int maxAdvance = std::min( dataBytes, m_dataBytes );
    m_dataStart += maxAdvance;
    m_dataBytes -= maxAdvance; 
  }

  void Clear()
  {
    m_dataBytes = 0;
    m_dataStart = 0;
  }

  int GetBytesInBuffer() const { return m_dataBytes; }
  int GetBufferBytes() const { return m_bufferBytes; }

  byte* m_buffer;
  int m_bufferBytes;
  int m_dataStart;
  int m_dataBytes;
};

#endif
