using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace AnimationTestXMLGenerator
{
    class Program
    {
        static void Main(string[] args)
        {
            string objectsSource;
            string xmlFile;

            if (ValidateCommandLine(args, out objectsSource, out xmlFile))
            {
                Start(objectsSource, xmlFile);
                Environment.ExitCode = 0;
            }
            else
            {
                PrintUsage();
                Environment.ExitCode = 1;
            }

            Console.WriteLine("AnimationTestXMLGenerator Result: " + Environment.ExitCode);
        }

        private static void Start(string objectsSource, string xmlFile)
        {
            SearchCharacters searchCharacters = null;
            if (File.Exists(objectsSource))
                searchCharacters = new SearchCharatersInPak(objectsSource);
            else
                searchCharacters = new SearchCharatersInFolder(objectsSource);

            XmlWriter xmlWriter = new XmlWriter();
            xmlWriter.Write(xmlFile, searchCharacters);
        }

        private static bool ValidateCommandLine(String[] args, out string objectsSource, out string xmlFile)
        {
            if (args.Length != 2)
            {
                objectsSource = null;
                xmlFile = null;
                return false;
            }

            objectsSource = args[0];
            xmlFile = args[1];

            if (!File.Exists(objectsSource) && !Directory.Exists(objectsSource))
            {
                Console.WriteLine("Objects source does not exists");
                return false;
            }

            return true;
        }

        private static void PrintUsage()
        {
            Console.WriteLine("Usage: AnimationTestXMLGenarator.exe [objects-source in] [xml-file out]");
        }
    }
}
