using System;
using System.Collections.Generic;
using System.IO;
using Ionic.Zip;

namespace AnimationTestXMLGenerator
{
    abstract class SearchCharacters
    {
        protected void AddCharacter(ICollection<string> characters, string fileName)
        {
            if (fileName.EndsWith(".chr"))
            {
                characters.Add(fileName);
            }
        }

        public abstract ICollection<string> Search();
    }

    class SearchCharatersInFolder : SearchCharacters
    {
        DirectoryInfo objectsDirectory;

        public SearchCharatersInFolder(string objectsDirectory)
        {
            this.objectsDirectory = new DirectoryInfo(objectsDirectory);
        }

        private string ConvertToReleativeUnixFormat(FileInfo fileInfo)
        {
            string fileName = fileInfo.FullName.Substring(this.objectsDirectory.Parent.FullName.Length);
            fileName = fileName.Replace(@"\", "/");
            if (fileName.StartsWith("/"))
            {
                fileName = fileName.Substring(1);
            }
            return fileName;
        }

        private void SearchInDirectory(ICollection<string> characters, DirectoryInfo directory)
        {
            foreach (DirectoryInfo directoryInfo in directory.GetDirectories())
            {
                SearchInDirectory(characters, directoryInfo);
            }
            foreach (FileInfo fileInfo in directory.GetFiles())
            {
                AddCharacter(characters, ConvertToReleativeUnixFormat(fileInfo));
            }
        }

        public override ICollection<string> Search()
        {
            ICollection<string> characters = new List<string>();
            SearchInDirectory(characters, objectsDirectory);
            return characters;
        }
    }

    class SearchCharatersInPak : SearchCharacters
    {
        private ZipFile objectsPak;

        public SearchCharatersInPak(string objectsPak)
        {
            this.objectsPak = new ZipFile(objectsPak);
        }

        public override ICollection<string> Search()
        {
            ICollection<string> characters = new List<string>();
            foreach (ZipEntry entry in objectsPak)
            {
                AddCharacter(characters, entry.FileName);
            }
            return characters;
        }
    }
}
