using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace AnimationTestXMLGenerator
{
    class XmlWriter
    {
        public void Write(string xmlFile, SearchCharacters searchCharacters)
        {
            using (XmlTextWriter writer = new XmlTextWriter(xmlFile, Encoding.Default))
            {
                writer.WriteStartDocument();
                writer.WriteStartElement("Suite");

                WriteTest(writer);
                WriteCharacters(writer, searchCharacters);

                writer.WriteEndElement();
                writer.WriteEndDocument();
            }
        }

        private void WriteTest(XmlTextWriter writer)
        {
            writer.WriteStartElement("Test");

            writer.WriteAttributeString("name", "TestLoadingAll");
            writer.WriteAttributeString("class", "TestLoading");

            writer.WriteStartElement("Character");
            writer.WriteAttributeString("name", "all");
            writer.WriteEndElement();

            writer.WriteEndElement();
        }

        private void WriteCharacters(XmlTextWriter writer, SearchCharacters searchCharacters)
        {
            writer.WriteStartElement("Character");
            writer.WriteAttributeString("name", "all");

            foreach (string character in searchCharacters.Search())
            {
                writer.WriteStartElement("File");
                writer.WriteAttributeString("name", character);
                writer.WriteEndElement();
            }

            writer.WriteEndElement();
        }
    }
}
