<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">
    <html>
      <head>
        <style type="text/css">
          table
          {
            border: 1px solid #808080;
          }
          tr.testsuccess
          {
            background-color: #81F781;
          }
          tr.testfailure
          {
            background-color: #FA5858;
          }
          td
          {
            border: 1px solid #000000;
            padding: 3px;
          }
        </style>
      </head>
      <body>
        <xsl:for-each select="testsuite">
          <h3>
            <xsl:value-of select="@name"/>
          </h3>
          <h4>
            Tests <xsl:value-of select="@tests"/> Failures <xsl:value-of select="@failures"/> Errors <xsl:value-of select="@errors"/> Time <xsl:value-of select="@time"/>s
          </h4>
        </xsl:for-each>
        <table>
          <tr>
            <th>Name</th>
            <th>Class</th>
            <th>Character</th>
            <th>Animation</th>
            <th>Type</th>
            <th>Message</th>
            <th>Condition</th>
            <th>Filename</th>
            <th>FileLineNumber</th>
          </tr>
          <xsl:for-each select="testsuite/testcase">
            <tr>
              <xsl:choose>
                <xsl:when test="failure">
                  <xsl:attribute name="class">testfailure</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="class">testsuccess</xsl:attribute>
                </xsl:otherwise>
              </xsl:choose>

              <td><xsl:value-of select="@name"/></td>
              <td><xsl:value-of select="@class"/></td>
              <td><xsl:value-of select="@character"/></td>
              <td><xsl:value-of select="@animation"/></td>
              <td><xsl:value-of select="failure/@type"/></td>
              <td><xsl:value-of select="failure/@message"/></td>
              <td><xsl:value-of select="failure/details/@condition"/></td>
              <td><xsl:value-of select="failure/details/@filename"/></td>
              <td><xsl:value-of select="failure/details/@filelinenumber"/></td>

            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
