using System;
using System.IO;

namespace AnimationTesting
{
	class Program
	{
		private static Suite CreateSuite(string xmlFile)
		{
			Suite suite = new Suite();
			try
			{
				suite.Load(new StreamReader(xmlFile));
			}
			catch (Exception exception)
			{
				Console.WriteLine(exception.Message);
				suite = null;
			}
			return suite;
		}

		private static OutputWriter CreateOutputWriter(string report)
		{
			OutputWriter outputWriter = null;
			if (report != null)
			{
				string directoryName = Path.GetDirectoryName(report);

				if (directoryName != null && directoryName.Length != 0)
					Directory.CreateDirectory(directoryName);

				outputWriter = new XmlOutputWriter(report);
			}
			else
			{
				outputWriter = new ConsoleOutputWriter();
			}
			return outputWriter;
		}

		static void Main(string[] args)
		{
			CommandLineArguments commandLineArguments = new CommandLineArguments();
			commandLineArguments.ParseArguments(args);

			Suite suite = CreateSuite(commandLineArguments.Suite);
			if (suite != null)
			{
				OutputWriter outputWriter = CreateOutputWriter(commandLineArguments.Report);

				Engine engine = new Engine(commandLineArguments.Binaries);
				Runner runner = new Runner(engine, outputWriter);
				runner.Run(suite);

				outputWriter.Flush();
				Environment.ExitCode = runner.ExitCode;	
			}
			else
			{
				Console.WriteLine("Suite not valid");
				Environment.ExitCode = 1;
			}

			Console.WriteLine("AnimationTesting Result: " + Environment.ExitCode);
		}
	}
}
