using System.Collections.Generic;
using System.Text.RegularExpressions;
using CryAnimationTesting.Wrapper;

namespace AnimationTesting
{
	public class CharacterTestRunner
	{
		private Engine m_engine;
		private TestListener m_testListener;
		private Character m_character;

		public CharacterTestRunner(Engine engine, TestListener testListener, string characterName)
		{
			m_engine = engine;
			m_testListener = testListener;
			m_character = new Character(m_engine, characterName);
		}

		private bool Matches(ICollection<string> patterns, string name)
		{
			foreach (string p in patterns)
			{
				Regex regex = new Regex(p, RegexOptions.IgnoreCase);
				if (regex.Match(name).Success)
					return true;
			}
			return false;
		}

		private void RunTestCase(Test test, TestClass testClass, string animName)
		{
			TestContext testContext = new TestContext(m_engine, test.Name, m_character, animName);
			foreach (ConfigElement configElement in test.ConfigElementCollection)
			{
				TestConfigElement testConfigElement = testContext.AddConfigElement(configElement.Name);
				foreach (KeyValuePair<string, string> keyValuePair in configElement.ElementDictionary)
				{
					testConfigElement.Add(keyValuePair.Key, keyValuePair.Value);
				}
			}
			testClass.Run(testContext, m_testListener);
		}

		public void Run(Test test, TestClass testClass)
		{
			if (test.Animations.Count == 0)
			{
				RunTestCase(test, testClass, "");
			}
			else
			{
				foreach (string animName in m_character.AnimationNames)
				{
					if (Matches(test.Animations, animName))
					{
						RunTestCase(test, testClass, animName);
					}
				}
			}
		}
	}
}
