using System;
using System.Collections.Generic;
using System.Text;
using CryAnimationTesting.Wrapper;

namespace AnimationTesting
{
	public class Runner : TestListener
	{
		private Engine m_engine;
		private OutputWriter m_runnerOutput;
		private int m_exitCode = 0;

		public Runner(Engine engine, OutputWriter runnerOutput)
			:	base(engine)
		{
			m_engine = engine;
			m_runnerOutput = runnerOutput;
			m_exitCode = 0;
		}

		public override void TestPassed(TestContext testContext, TestRunInfo testRunInfo)
		{
			m_runnerOutput.TestPassed(testContext, testRunInfo);
		}

		public override void TestFailed(TestContext testContext, TestRunInfo testRunInfo)
		{
			m_exitCode = 1;
			m_runnerOutput.TestFailed(testContext, testRunInfo);
		}

		public int ExitCode
		{
			get { return m_exitCode; }
		}

		public void Run(Suite suite)
		{
			foreach (Test test in suite)
			{
				TestClass testClass = m_engine.FindAnimationTestClass(test.Class);
				if (testClass != null)
				{
					RunTest(test, testClass);
				}
				else
				{
					m_exitCode = 1;
					m_runnerOutput.TestClassNotFound(test);
				}
			}
		}

		private void RunTest(Test test, TestClass testClass)
		{
			foreach (string fileName in test.Characters)
			{
				try
				{
					CharacterTestRunner characterTestRunner = new CharacterTestRunner(m_engine, this, fileName);
					characterTestRunner.Run(test, testClass);
				}
				catch (CharacterAssertException assertException)
				{
					m_exitCode = 1;
					m_runnerOutput.FatalError(test, assertException);
				}
				catch (CharacterException exception)
				{
					m_exitCode = 1;
					m_runnerOutput.FatalError(test, exception);
				}
			}
		}
	}
}
