#include "StdAfx.h"
#include "AnimationTestingFixture.h"
#include "Interfaces/ITestContext.h"
#include "Interfaces/ICharacter.h"

using namespace CryAnimationTesting;

void AnimationTestingFixture::SetContext(const ITestContext& testContext)
{
	m_animationName = testContext.GetAnimationName();
	m_characterInstance = testContext.GetCharacter()->GetCharacterInstance();
	m_configElementCollection = testContext.GetConfigElementCollection();
}

ICharacterInstance* AnimationTestingFixture::GetCharacterInstance() const
{
	return m_characterInstance;
}

const string& AnimationTestingFixture::GetAnimationName() const
{
	return m_animationName;
}

const IConfigElementCollection& AnimationTestingFixture::GetConfigElementCollection() const
{
	return *m_configElementCollection;
}
