#ifndef CRY_ANIMATION_TESTING_ANIMATION_TESTING_SUITE_H
#define CRY_ANIMATION_TESTING_ANIMATION_TESTING_SUITE_H

#include <ICryAnimation.h>
#include <CryUnit.h>
#include "Interfaces/IConfigElement.h"

namespace CryAnimationTesting
{
	struct ITestContext;

	DECLARE_TEST_SUITE(AnimationTestingSuite);

	CRY_TEST_FIXTURE(AnimationTestingFixture, CryUnit::ITestFixture, AnimationTestingSuite)
	{
	public:
		void SetContext(const ITestContext& testContext);

		ICharacterInstance* GetCharacterInstance() const;
		const string& GetAnimationName() const;
		const IConfigElementCollection& GetConfigElementCollection() const;
	private:
		ICharacterInstance* m_characterInstance;
		IConfigElementCollection* m_configElementCollection;
		string m_animationName;
	};
}

#endif
