#include "StdAfx.h"
#include "Character.h"
#include <ICryAnimation.h>
using namespace CryAnimationTesting;

Character::Character(ICharacterInstance* characterInstance, const string& characterName)
	: m_characterInstance(characterInstance)
	, m_animationSet(m_characterInstance->GetIAnimationSet())
	, m_characterName(characterName)
{

}

void Character::Release()
{
	delete this;
}

ICharacterInstance* Character::GetCharacterInstance() const
{
	return m_characterInstance;
}

int Character::GetNumAnimations() const
{
	return m_animationSet->numAnimations();
}

const char* Character::GetAnimationName(int i) const
{
	return m_animationSet->GetNameByAnimID(i);
}

const char* Character::GetCharacterName() const
{
	return m_characterName.c_str();
}
