#ifndef CRY_ANIMATION_TESTING_CHARACTER_H
#define CRY_ANIMATION_TESTING_CHARACTER_H

#include "Interfaces/ICharacter.h"

struct ICharacterInstance;
struct IAnimationSet;

namespace CryAnimationTesting
{
	class Character : public ICharacter
	{
	public:
		Character(ICharacterInstance* characterInstance, const string& characterName);
		virtual void Release();

		virtual ICharacterInstance* GetCharacterInstance() const;

		virtual int GetNumAnimations() const;
		virtual const char* GetAnimationName(int i) const;
		virtual const char* GetCharacterName() const;
	private:
		ICharacterInstance* m_characterInstance;
		IAnimationSet* m_animationSet;
		string m_characterName;
	};
}

#endif
