#include "Stdafx.h"
#include "ConfigElement.h"

using namespace CryAnimationTesting;

ConfigElement::ConfigElement(const string& name)
	: m_name(name)
{

}

void ConfigElement::Add(const char* key, const char* value)
{
	m_attributes.insert(std::make_pair(key, value));
}

const char* ConfigElement::GetName() const
{
	return m_name.c_str();
}

const char* ConfigElement::Get(const char* key) const
{
	Attributes::const_iterator it = m_attributes.find(key);
	return (it != m_attributes.end()) ? it->second.c_str() : NULL;
}

ConfigElementCollection::~ConfigElementCollection()
{
	for (Elements::const_iterator it = m_elements.begin(); it != m_elements.end(); ++it)
	{
		delete *it;
	}
}

ConfigElement* ConfigElementCollection::Add(const char* elementName)
{
	ConfigElement* configElement = new ConfigElement(elementName);
	m_elements.push_back(configElement);
	return configElement;
}

ConfigElement* ConfigElementCollection::FindFirstByName(const char* elementName) const
{
	ConfigElement* res = NULL;
	for (Elements::const_iterator it = m_elements.begin(); it != m_elements.end(); ++it)
	{
		if (0 == strcmp(elementName, (*it)->GetName()))
		{
			res = *it;
			break;
		}
	}
	return res;
}

int ConfigElementCollection::GetSize() const
{
	return (int) m_elements.size();
}

ConfigElement* ConfigElementCollection::Get(int idx) const
{
	return m_elements.at(idx);
}
