#ifndef CRY_ANIMATION_TESTING_CONFIG_ELEMENT_H
#define CRY_ANIMATION_TESTING_CONFIG_ELEMENT_H

#include <vector>
#include <map>

#include "Interfaces/IConfigElement.h"

namespace CryAnimationTesting
{
	class ConfigElement : public IConfigElement
	{
		typedef std::map<string, string> Attributes;
	public:
		ConfigElement(const string& name);

		virtual void Add(const char* key, const char* value);

		virtual const char* GetName() const;
		virtual const char* Get(const char* key) const;

	private:
		string m_name;
		Attributes m_attributes;
	};

	class ConfigElementCollection : public IConfigElementCollection
	{
		typedef std::vector<ConfigElement*> Elements;
	public:
		~ConfigElementCollection();

		virtual ConfigElement* Add(const char* elementName);
		virtual ConfigElement* FindFirstByName(const char* elementName) const;
		virtual int GetSize() const;
		virtual ConfigElement* Get(int idx) const;

	private:
		Elements m_elements;
	};
}

#endif
