#include "StdAfx.h"
#include "Engine.h"
#include "Character.h"
#include "TestClass.h"
#include "TestContext.h"
#include "AnimationTestingFixture.h"
using namespace CryAnimationTesting;

#include <ISystem.h>
#include <ICryAnimation.h>
#include <CryUnitInterfaces.h>
#include "Interfaces/IErrorListener.h"

void Engine::Release()
{
	delete this;
}

bool Engine::Initialize(const char* binaries)
{
	return m_systemStartup.Initialize(binaries);
}

ICharacter* Engine::CreateCharacter(const char* name, IErrorListener& errorListener)
{
	ICharacter* res = NULL;
	ICharacterInstance* characterInstance = NULL;
	try 
	{
		SSystemGlobalEnvironment* env = m_systemStartup.GetSystem()->GetGlobalEnvironment();
		characterInstance = env->pCharacterManager->CreateInstance(name);
	}
	catch (const CryUnit::ITestFailedException& e)
	{
		errorListener.OnCryAssert(e.GetCondition(), e.GetMessage(), e.GetFilePath(), e.GetFileLine());
		if (characterInstance)
			SAFE_RELEASE(characterInstance);
	}

	if (characterInstance)
		res =  new Character(characterInstance, name);

	return res;
}

ITestClass* Engine::FindAnimationTestClass(const wchar_t* name)
{
	ITestClass* res = 0;
	const CryUnit::ITestSuite* testSuite = AnimationTestingSuite::GetInstance();
	const CryUnit::STestInfo* testInfo = testSuite->GetTestInfoByName(name);
	if (testInfo)
	{
		res = new TestClass(*testSuite, *testInfo);
	}
	return res;
}

ITestContext* Engine::CreateTestContext(ICharacter* character, const char* animationName)
{
	return new TestContext(character, animationName);
}

extern "C" __declspec(dllexport) IEngine* CryAnimationTestingCreate()
{
	return new Engine();
}
