#ifndef CRY_ANIMATION_TESTING_ENGINE_H
#define CRY_ANIMATION_TESTING_ENGINE_H

#include "Interfaces/IEngine.h"
#include "SystemStartup.h"

namespace CryAnimationTesting
{
	class Engine : public IEngine
	{
	public:
		virtual void Release();
		virtual bool Initialize(const char* binaries);

		virtual ICharacter* CreateCharacter(const char* name, IErrorListener& errorListener);
		virtual ITestClass* FindAnimationTestClass(const wchar_t* name);
		virtual ITestContext* CreateTestContext(ICharacter* character, const char* animationName);

	private:
		SystemStartup m_systemStartup;
	};
}

#endif
