#ifndef CRY_ANIMATION_TESTING_ICHARACTER_H
#define CRY_ANIMATION_TESTING_ICHARACTER_H

struct ICharacterInstance;

namespace CryAnimationTesting
{
	struct IEngine;

	struct ICharacter
	{
		virtual void Release() = 0;

		virtual int GetNumAnimations() const = 0;
		virtual const char* GetAnimationName(int i) const = 0;
		virtual const char* GetCharacterName() const = 0;
		virtual ICharacterInstance* GetCharacterInstance() const = 0;
	};
}

#endif
