#ifndef CRY_ANIMATION_TESTING_ICONFIG_ELEMENT_H
#define CRY_ANIMATION_TESTING_ICONFIG_ELEMENT_H

namespace CryAnimationTesting
{
	struct IConfigElement
	{
		virtual ~IConfigElement() {}

		virtual void Add(const char* key, const char* value) = 0;

		virtual const char* GetName() const = 0;
		virtual const char* Get(const char* key) const = 0;
	};

	struct IConfigElementCollection
	{
		virtual ~IConfigElementCollection() {};

		virtual IConfigElement* Add(const char* elementName) = 0;
		virtual IConfigElement* FindFirstByName(const char* elementName) const = 0;
		virtual int GetSize() const = 0;
		virtual IConfigElement* Get(int idx) const = 0;
	};
}

#endif
