#ifndef CRY_ANIMATION_TESTING_IENGINE_H
#define CRY_ANIMATION_TESTING_IENGINE_H

namespace CryAnimationTesting
{
	struct IEngine;
	struct ICharacter;
	struct ITestClass;
	struct ITestContext;
	struct IErrorListener;

	typedef IEngine* (*CreateEngine)();

	struct IEngine
	{
		virtual bool Initialize(const char* binaries) = 0;
		virtual void Release() = 0;

		virtual ICharacter* CreateCharacter(const char* name, IErrorListener& errorListener) = 0;
		virtual ITestContext* CreateTestContext(ICharacter* character, const char* animationName) = 0;
 		virtual ITestClass* FindAnimationTestClass(const wchar_t* name) = 0;
	};
}

#endif
