#include "StdAfx.h"
#include "AnimationTestingFixture.h"
using namespace CryAnimationTesting;

CRY_TEST_WITH_FIXTURE(MyTestCase, AnimationTestingFixture)
{
	ICharacterInstance* characterInstance = GetCharacterInstance();
	const char* animationName = GetAnimationName();

	ASSERT_IS_NOT_NULL(characterInstance);
	ASSERT_IS_NOT_NULL(strstr(animationName, "walk"));

	const IConfigElementCollection& configElementCollection = GetConfigElementCollection();
	ASSERT_ARE_EQUAL(3, configElementCollection.GetSize());

	IConfigElement* configElementFirstJoint = configElementCollection.FindFirstByName("Joint");
	IConfigElement* configElementSecondJoint = configElementCollection.Get(1);
	IConfigElement* configElementMyTest = configElementCollection.FindFirstByName("MyTest");

	ASSERT_ARE_EQUAL("Joint", configElementFirstJoint->GetName());
	ASSERT_ARE_EQUAL("Joint", configElementSecondJoint->GetName());
	ASSERT_ARE_EQUAL("MyTest", configElementMyTest->GetName());

	ASSERT_ARE_EQUAL("LocomotionLocator", configElementFirstJoint->Get("name"));
	ASSERT_ARE_EQUAL("10", configElementFirstJoint->Get("metersPerSecond"));
	ASSERT_ARE_EQUAL("360", configElementFirstJoint->Get("degreesPerSecond"));

	ASSERT_ARE_EQUAL("Root", configElementSecondJoint->Get("name"));
	ASSERT_ARE_EQUAL("5", configElementSecondJoint->Get("metersPerSecond"));
	ASSERT_ARE_EQUAL("180", configElementSecondJoint->Get("degreesPerSecond"));

	ASSERT_ARE_EQUAL("abc", configElementMyTest->Get("value1"));
	ASSERT_ARE_EQUAL("def", configElementMyTest->Get("value2"));
}
