#include "StdAfx.h"
#include "SkeletonPoseIterator.h"
#include <ICryAnimation.h>
using namespace CryAnimationTesting;

SkeletonPoseIterator::SkeletonPoseIterator(ICharacterInstance* characterInstance, const char* animationName)
    : m_characterInstance(characterInstance)
    , m_skeletonAnim(characterInstance->GetISkeletonAnim())
    , m_skeletonPose(characterInstance->GetISkeletonPose())
    , m_animationSet(characterInstance->GetIAnimationSet())
    , m_numberOfPoses(ComputeNumberOfPoses(animationName))
    , m_poseIdx(0)
{
    StartAnimation(animationName);
}

SkeletonPoseIterator::~SkeletonPoseIterator()
{
    Close();
}

void SkeletonPoseIterator::Close()
{
    while (HasNext())
    {
        MoveNext();
    }
}

bool SkeletonPoseIterator::HasNext() const
{
    return m_poseIdx < m_numberOfPoses;
}

void SkeletonPoseIterator::MoveNext()
{
    bool found = false;
    do 
    {
        m_poseIdx++;
        uint32 numAnimsInFIFO = m_skeletonAnim->GetNumAnimsInFIFO(0);
        if (numAnimsInFIFO)
        {
            found = FindAnimation(numAnimsInFIFO);
        }
    }
    while (!found && m_poseIdx < m_numberOfPoses);
}

bool SkeletonPoseIterator::FindAnimation(uint32 numAnimsInFIFO) const
{
    CAnimation& anim = m_skeletonAnim->GetAnimFromFIFO(0,numAnimsInFIFO-1);

    bool found = anim.m_LMG.m_nGlobalLMGID < 0;
    if (found)
    {
        f32 newtime = (1.0f / m_numberOfPoses) * m_poseIdx;
        anim.m_fAnimTime = newtime;
        anim.m_fAnimTimePrev = newtime;
        gEnv->pCharacterManager->Update();
        m_skeletonPose->SetForceSkeletonUpdate(55);
        m_characterInstance->SkeletonPreProcess(IDENTITY, IDENTITY, CCamera(), 0);
        m_characterInstance->SkeletonPostProcess(IDENTITY, IDENTITY, 0, 0.0f, 0);
    }	
    return found;
}

ISkeletonPose* SkeletonPoseIterator::GetCurrent() const
{
    return m_skeletonPose;
}

uint32 SkeletonPoseIterator::ComputeNumberOfPoses(const char* animationName) const
{
    int32 animationID = m_animationSet->GetAnimIDByName(animationName);
    f32 duration = m_animationSet->GetDuration_sec(animationID); 
    float posesPerSec = 1.0f/30.0f;
    uint32 numberOfPoses = uint32(duration/posesPerSec);
    return numberOfPoses;
}

void SkeletonPoseIterator::StartAnimation(const char* animationName) const
{
    CryCharAnimationParams params;
    params.m_nFlags = CA_MANUAL_UPDATE;
    m_skeletonAnim->ClearFIFO(0);
    m_skeletonAnim->StartAnimation(animationName, params);
}
