#ifndef CRY_ANIMATION_TESTING_SKELETON_POSE_ITERATOR_H
#define CRY_ANIMATION_TESTING_SKELETON_POSE_ITERATOR_H

struct ICharacterInstance;
struct ISkeletonAnim;
struct ISkeletonPose;
struct IAnimationSet;

namespace CryAnimationTesting
{
    class SkeletonPoseIterator
    {
    public:
        SkeletonPoseIterator(ICharacterInstance* characterInstance, const char* animationName);
        ~SkeletonPoseIterator();

        bool HasNext() const;
        void MoveNext();
        ISkeletonPose* GetCurrent() const;

    private:
        void Close();

        uint32 ComputeNumberOfPoses(const char* animationName) const;
        void StartAnimation(const char* animationName) const;
        bool FindAnimation(uint32 numAnimsInFIFO) const;

        ICharacterInstance* m_characterInstance;
        ISkeletonAnim* m_skeletonAnim;
        ISkeletonPose* m_skeletonPose;
        IAnimationSet* m_animationSet;
        const uint32 m_numberOfPoses;
        uint32 m_poseIdx;
    };
}

#endif

