#include "StdAfx.h"
#include "SystemStartup.h"
using namespace CryAnimationTesting;

#include <platform.h>
#include <platform_impl.h>
#include <ISystem.h>

SystemStartup::SystemStartup()
	: m_systemModule(NULL)
	, m_system(NULL)
{
	m_RootDir[0] = '\0';
	m_BinariesDir[0] = '\0';
	m_BinariesRelativeDir[0] = '\0';
}

SystemStartup::~SystemStartup()
{
	//SAFE_RELEASE(m_system) // NO WAY!!!

	if (m_systemModule)
		::FreeLibrary(m_systemModule);
}

ISystem* SystemStartup::GetSystem() const
{
	return m_system;
}

bool SystemStartup::InitDirectories(const char* binaries)
{
	strcpy_s(m_BinariesRelativeDir, binaries);
	GetModuleFileName(GetModuleHandle(0), m_RootDir, sizeof(m_RootDir));
	bool res = ExtractRootDirFromModuleName(m_RootDir);
	if (res)
	{
		SetCurrentDirectory(m_RootDir);
		strcpy_s(m_BinariesDir, m_RootDir);
		strcat_s(m_BinariesDir, binaries);		
	}
	return res;
}

bool SystemStartup::ExtractRootDirFromModuleName(char* moduleFileName)
{
	const char* lookFor = "Bin";
	int lookForLen = strlen(lookFor);

	for (int i = strlen(moduleFileName) - 1; i >= 0; i--)
	{
		if (0 == strncmp(&moduleFileName[i], lookFor, lookForLen))
		{
			moduleFileName[i] = '\0';
			return true;
		}
	}
	return false;
}

HMODULE SystemStartup::LoadLibrary(const char* libraryName)
{
	char currentDirectory[256];
	GetCurrentDirectory(256, currentDirectory);

	SetCurrentDirectory(m_BinariesDir);

	HMODULE module = ::LoadLibrary(libraryName);

	SetCurrentDirectory(currentDirectory);

	return module;
}

bool SystemStartup::InitializeSystem()
{
	m_systemModule = LoadLibrary("CrySystem.dll");
	if (m_systemModule)
	{
		PFNCREATESYSTEMINTERFACE createSystemInterface = (PFNCREATESYSTEMINTERFACE) GetProcAddress(m_systemModule, "CreateSystemInterface");
		if (createSystemInterface)
		{
			SSystemInitParams initParams;
			SCvarsDefault cvarsDefault;
			cvarsDefault.sz_r_DriverDef = "Null";
			strcpy_s(initParams.szBinariesDir, m_BinariesRelativeDir);
			initParams.pCvarsDefault = &cvarsDefault;
			initParams.bTesting = true;
			initParams.bSkipInput = true;

			m_system = createSystemInterface(initParams);
			ModuleInitISystem(m_system, "AnimationTest");
		}
	}
	return m_system != NULL;
}

LRESULT CALLBACK SystemStartup::WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

void SystemStartup::RegisterClass()
{
	WNDCLASSEX wc = { 0 };

	wc.cbSize        = sizeof(WNDCLASSEX);
	wc.style         = CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc   = WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = GetModuleHandle(0);
	wc.lpszClassName = "CryENGINE";
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = 0;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	RegisterClassEx(&wc);
}

bool SystemStartup::Initialize(const char* binaries)
{
	RegisterClass();

	DWORD lastError = GetLastError();
	bool res = InitDirectories(binaries);

	if (res)
	{
		res = InitializeSystem();
	}

	return res;
}
