#ifndef CRY_ANIMATION_TESTING_SYSTEM_STARTUP_H
#define CRY_ANIMATION_TESTING_SYSTEM_STARTUP_H

struct ISystem;

namespace CryAnimationTesting
{
	class SystemStartup
	{
	public:
		SystemStartup();
		~SystemStartup();

		bool Initialize(const char* binaries);

		ISystem* GetSystem() const;

	private:
		HMODULE LoadLibrary(const char* libraryName);
		bool InitDirectories(const char* binaries);
		bool InitializeSystem();

		static bool ExtractRootDirFromModuleName(char* moduleFileName);
		static LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
		void RegisterClass();

		char m_RootDir[256];
		char m_BinariesDir[256];
		char m_BinariesRelativeDir[32];

		HMODULE m_systemModule;
		ISystem* m_system;
	};
}

#endif
