#include "StdAfx.h"
#include "TestClass.h"
#include "Interfaces/ITestListener.h"
#include "Interfaces/ITestContext.h"
#include "Interfaces/ICharacter.h"
#include "AnimationTestingFixture.h"
using namespace CryAnimationTesting;

TestClass::Listener::Listener(CryAnimationTesting::ITestListener& listener, const ITestContext& testContext)
	: m_listener(listener)
	, m_testContext(testContext)
{

}

void TestClass::Listener::TestSuiteRun(const CryUnit::ITestSuite& testSuite)
{

}

void TestClass::Listener::TestSuiteEnd(const CryUnit::ITestSuite& testSuite)
{

}

void TestClass::Listener::StartTestRun(const CryUnit::STestInfo& testInfo)
{

}

void TestClass::Listener::TestRun(const CryUnit::STestInfo& testInfo)
{

}

void TestClass::Listener::TestPassed(const CryUnit::STestInfo& testInfo)
{
	m_listener.TestPassed(m_testContext, testInfo.Name);
}

void TestClass::Listener::TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo)
{
	m_listener.TestFailed(m_testContext, testInfo.Name, failureInfo.Condition, failureInfo.Message, failureInfo.FileName, failureInfo.FileLineNumber);
}

void TestClass::Listener::TestSkipped(const CryUnit::STestInfo& testInfo)
{

}

TestClass::TestClass(const CryUnit::ITestSuite& testSuite, const CryUnit::STestInfo& testInfo)
	: m_testSuite(testSuite)
	, m_testInfo(testInfo)
{

}

void TestClass::Release()
{
	delete this;
}

void TestClass::Run(const ITestContext& testContext, ITestListener& testListener)
{
	CryUnit::ITestCase* testCase = m_testInfo.TestFactory();

	AnimationTestingFixture* animationTestCase = dynamic_cast<AnimationTestingFixture*>(testCase); //FIXME: need to find a better way to do this (should not involve this cast).
	if (animationTestCase)
	{
		animationTestCase->SetContext(testContext);
	}

	Listener internalListener(testListener, testContext);
	m_testSuite.RunTestCase(*animationTestCase, internalListener);

	delete testCase;
}
