#ifndef CRY_ANIMATION_TESTING_TEST_CLASS_H
#define CRY_ANIMATION_TESTING_TEST_CLASS_H

#include "Interfaces/ITestClass.h"
#include <CryUnitInterfaces.h>

namespace CryAnimationTesting
{
	class TestClass : public ITestClass
	{
		class Listener : public CryUnit::ITestListener
		{
		public:
			Listener(CryAnimationTesting::ITestListener& lListener, const ITestContext& testContext);
			virtual void TestSuiteRun(const CryUnit::ITestSuite& testSuite);
			virtual void TestSuiteEnd(const CryUnit::ITestSuite& testSuite);

			virtual void StartTestRun(const CryUnit::STestInfo& testInfo);
			virtual void TestRun(const CryUnit::STestInfo& testInfo);
			virtual void TestPassed(const CryUnit::STestInfo& testInfo);
            virtual void TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo);
			virtual void TestSkipped(const CryUnit::STestInfo& testInfo);
		private:
			CryAnimationTesting::ITestListener& m_listener;
			const ITestContext& m_testContext;
		};
	public:
		TestClass(const CryUnit::ITestSuite& testSuite, const CryUnit::STestInfo& testInfo);

		virtual void Release();
		virtual void Run(const ITestContext& testContext, ITestListener& testListener);
	private:
		const CryUnit::ITestSuite& m_testSuite;
		const CryUnit::STestInfo& m_testInfo;
	};
}

#endif
