#include "Stdafx.h"
#include "TestContext.h"
#include "ConfigElement.h"
using namespace CryAnimationTesting;

TestContext::TestContext(ICharacter* character, const string& animationName)
	: m_character(character)
	, m_animationName(animationName)
	, m_configElementCollection(new ConfigElementCollection())
{

}

TestContext::~TestContext()
{
	delete m_configElementCollection;
}

void TestContext::Release()
{
	delete this;
}

ICharacter* TestContext::GetCharacter() const
{
	return m_character;
}

const char* TestContext::GetAnimationName() const
{
	return m_animationName.c_str();
}

IConfigElementCollection* TestContext::GetConfigElementCollection() const
{
	return m_configElementCollection;
}
