#ifndef CRY_ANIMATION_TESTING_TEST_CONTEXT_H
#define CRY_ANIMATION_TESTING_TEST_CONTEXT_H

#include "Interfaces/ITestContext.h"

namespace CryAnimationTesting
{
	struct ICharacter;
	struct IConfigElementCollection;

	class TestContext : public ITestContext
	{
	public:
		TestContext(ICharacter* character, const string& animationName);
		~TestContext();
		virtual void Release();

		virtual ICharacter* GetCharacter() const;
		virtual const char* GetAnimationName() const;
		virtual IConfigElementCollection* GetConfigElementCollection() const;

	private:
		ICharacter* m_character;
		string m_animationName;
		IConfigElementCollection* m_configElementCollection;
	};
}

#endif
