#include "StdAfx.h"
#include "AnimationTestingFixture.h"
#include "SkeletonPoseIterator.h"
using namespace CryAnimationTesting;

CRY_TEST_WITH_FIXTURE(TestFirstPersonCameraPosition, AnimationTestingFixture)
{
    IConfigElement* jointInfo = GetConfigElementCollection().FindFirstByName("JointInfo");
    const char* headBoneName = jointInfo->Get("headBone");
    const char* cameraBoneName = jointInfo->Get("cameraBone");
    float maxDistance = (float)atof(jointInfo->Get("maxDistance"));

    for (SkeletonPoseIterator poseIterator(GetCharacterInstance(), GetAnimationName()); poseIterator.HasNext(); poseIterator.MoveNext())
    {
        ISkeletonPose* skeletonPose = poseIterator.GetCurrent();

        int16 cameraBoneId = skeletonPose->GetJointIDByName(headBoneName);
        int16 headBoneId = skeletonPose->GetJointIDByName(cameraBoneName);

        QuatT cameraLocation = skeletonPose->GetAbsJointByID(cameraBoneId);
        QuatT headLocation = skeletonPose->GetAbsJointByID(headBoneId);

        float distance = (cameraLocation.t - headLocation.t).len();
        if (distance >= maxDistance)
        {
            CRY_UNIT_FAIL_MESSAGE(wstring().Format(L"MaxDistanceExpected [%f] ActualDistance [%f]", maxDistance, distance).c_str());
        }
    }
}
