#include "Stdafx.h"
#include "Character.h"
#include "Engine.h"
#include "CharacterException.h"
#include <IEngine.h>
#include <ICharacter.h>
#include <IErrorListener.h>
#include <vcclr.h>

using namespace AnimationTesting;
using namespace CryAnimationTesting;
using namespace CryAnimationTesting::Wrapper;
using namespace System;
using namespace System::Collections::Generic;

class ErrorListener : public IErrorListener
{
public:
	ErrorListener(String^ characterName)
		: m_characterName(characterName)
		, m_assertException(nullptr)
	{

	}

	virtual void OnCryAssert(const wchar_t* condition, const wchar_t* message, const wchar_t* fileName, int fileLineNumber)
	{
		m_assertException = gcnew CharacterAssertException(m_characterName, gcnew String(condition), gcnew String(message), gcnew String(fileName), fileLineNumber);
	}

	void ThrowCharacterException() const
	{
		CharacterAssertException^ assertException = m_assertException;
		if (assertException != nullptr)
		{
			throw assertException;
		}
		else
		{
			throw gcnew CharacterException(m_characterName, gcnew String("Unable to load character"));
		}
	}

private:
	gcroot<String^> m_characterName;
	gcroot<CharacterAssertException^> m_assertException;
};

Character::Character(Engine^ engine, String^ fileName)
	: m_character(0)
{
	ErrorListener listener(fileName);
	CreateCharacter(engine, fileName, listener);

	if (!m_character)
		listener.ThrowCharacterException();
}

void Character::CreateCharacter(Engine^ engine, String^ fileName, IErrorListener& listener)
{
	IntPtr ansiFileName = Runtime::InteropServices::Marshal::StringToHGlobalAnsi(fileName);
	m_character = engine->GetIEngine()->CreateCharacter((char*)(void*)ansiFileName, listener);
	Runtime::InteropServices::Marshal::FreeHGlobal(ansiFileName);
}

Character::~Character()
{
	m_character->Release();
}

CryAnimationTesting::ICharacter* Character::GetICharacter()
{
	return m_character;
}

IEnumerable<String^>^ Character::AnimationNames::get()
{
	List<String^>^ animationNames = gcnew List<String^>();

	for (int i = 0; i < m_character->GetNumAnimations(); i++)
	{
		String^ animationName = gcnew String(m_character->GetAnimationName(i));
		animationNames->Add(animationName);
	}

	return animationNames;
}
