#pragma once

using System::String;
using System::Collections::Generic::IEnumerable;

namespace AnimationTesting
{
	ref class Engine;
}

namespace CryAnimationTesting
{
	struct ICharacter;
	struct IEngine;
	struct IErrorListener;

	namespace Wrapper
	{
		public ref class Character
		{
		public:
			Character(AnimationTesting::Engine^ engine, String^ fileName);
			~Character();

			ICharacter* GetICharacter();

			property IEnumerable<String^>^ AnimationNames
			{
				IEnumerable<String^>^ get();
			}

		private:
			void CreateCharacter(AnimationTesting::Engine^ engine, String^ fileName, IErrorListener& listener);
			ICharacter* m_character;
		};
	}
}
