#include "StdAfx.h"
#include "CharacterException.h"
using namespace System;

namespace AnimationTesting
{
	CharacterException::CharacterException(String^ characterName, String^ message)
		: Exception(message)
		, m_characterName(characterName)
	{

	}

	String^ CharacterException::CharacterName::get()
	{
		return m_characterName;
	}

	CharacterAssertException::CharacterAssertException(String^ characterName, String^ condition, String^ message, String^ fileName, int fileLineNumber)
		: CharacterException(characterName, message)
		, m_condition(condition)
		, m_fileName(fileName)
		, m_fileLineNumber(fileLineNumber)
	{

	}

	String^ CharacterAssertException::Condition::get()
	{
		return m_condition;
	}

	String^ CharacterAssertException::FileName::get()
	{
		return m_fileName;	
	}

	int CharacterAssertException::FileLineNumber::get()
	{
		return m_fileLineNumber;
	}
}
